/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.gene;

import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class JSGeneUtil {
    public static JSGeneData fromCompound(@Nullable CompoundTag tag) {
        if (tag == null || tag.isEmpty()) {
            return new JSGeneData();
        }
        JSGeneData data = new JSGeneData();
        data.loadFromNbt(tag);
        return data;
    }

    public static JSGeneData readFromStack(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return new JSGeneData();
        }
        CompoundTag tag = (CompoundTag)stack.get((DataComponentType)JSDataComponents.GENE_DATA.get());
        return JSGeneUtil.fromCompound(tag);
    }

    public static ItemStack writeToStack(ItemStack stack, JSGeneData geneData) {
        if (stack == null || stack.isEmpty() || geneData == null) {
            return stack;
        }
        CompoundTag tag = new CompoundTag();
        geneData.saveToNbt(tag);
        stack.set((DataComponentType)JSDataComponents.GENE_DATA.get(), (Object)tag);
        return stack;
    }

    public static ItemStack wipeStack(ItemStack stack) {
        if (stack != null && !stack.isEmpty()) {
            stack.remove((DataComponentType)JSDataComponents.GENE_DATA.get());
        }
        return stack;
    }
}

