/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.gene;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.GeneType;
import jp.jurassicsaga.server.base.generic.gene.obj.JSAggressiveInstinct;
import jp.jurassicsaga.server.base.generic.gene.obj.JSBoneDensity;
import jp.jurassicsaga.server.base.generic.gene.obj.JSCosmeticGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSDefaultEntityData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGenderLeanGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSInfertilityGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSIntensiveRepair;
import jp.jurassicsaga.server.base.generic.gene.obj.JSLightSkeleton;
import jp.jurassicsaga.server.base.generic.gene.obj.JSPlantData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSSizeGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSSkinToughness;
import jp.jurassicsaga.server.base.generic.gene.obj.JSToothHardness;
import jp.jurassicsaga.server.base.generic.gene.obj.JSToxicSkinGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSVenomBiteGene;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneItem;
import jp.jurassicsaga.server.base.item.obj.genetics.OtherDnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.PlantDnaItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import travelers.server.animal.obj.misc.AnimalType;

public class JSGenetics {
    public static final HashMap<JSGene, Supplier<Item>> GENE_ITEMS = new HashMap();
    public static final HashMap<ResourceLocation, JSGene> GENE_REGISTRY = new HashMap();
    public static final Hashtable<EntityType<?>, JSDefaultEntityData> ENTITY_DEFAULT_GENE_DATA = new Hashtable();
    public static final Hashtable<String, JSPlantData> PLANT_GENETIC_INFORMATION = new Hashtable();
    public static final ArrayList<JSGene> DEFAULT_GENES = new ArrayList();
    public static final JSGene VIVID_COSMETIC = JSGenetics.register(JSCommon.createId("vivid"), new JSCosmeticGene(JSVariants.VIVID, 0xC3C3C3, 3214658));
    public static final JSGene ALPINE_COSMETIC = JSGenetics.register(JSCommon.createId("alpine"), new JSCosmeticGene(JSVariants.ALPINE, 15915443, 3287840));
    public static final JSGene FOREST_COSMETIC = JSGenetics.register(JSCommon.createId("forest"), new JSCosmeticGene(JSVariants.FOREST, 6117429, 1382661));
    public static final JSGene JUNGLE_COSMETIC = JSGenetics.register(JSCommon.createId("jungle"), new JSCosmeticGene(JSVariants.JUNGLE, 12413756, 4528917));
    public static final JSGene OCEAN_COSMETIC = JSGenetics.register(JSCommon.createId("ocean"), new JSCosmeticGene(JSVariants.OCEAN, 9861733, 11050910));
    public static final JSGene PASTURE_COSMETIC = JSGenetics.register(JSCommon.createId("pasture"), new JSCosmeticGene(JSVariants.PASTURE, 4998965, 3025429));
    public static final JSGene RAINFOREST_COSMETIC = JSGenetics.register(JSCommon.createId("rainforest"), new JSCosmeticGene(JSVariants.RAINFOREST, 8094063, 5002584));
    public static final JSGene RIVER_COSMETIC = JSGenetics.register(JSCommon.createId("river"), new JSCosmeticGene(JSVariants.RIVER, 7644505, 10042162));
    public static final JSGene SAVANNA_COSMETIC = JSGenetics.register(JSCommon.createId("savanna"), new JSCosmeticGene(JSVariants.SAVANNA, 4142384, 13869657));
    public static final JSGene STEPPE_COSMETIC = JSGenetics.register(JSCommon.createId("steppe"), new JSCosmeticGene(JSVariants.STEPPE, 3286302, 8274465));
    public static final JSGene TAIGA_COSMETIC = JSGenetics.register(JSCommon.createId("taiga"), new JSCosmeticGene(JSVariants.TAIGA, 3294510, 1446415));
    public static final JSGene TROPICAL_COSMETIC = JSGenetics.register(JSCommon.createId("tropical"), new JSCosmeticGene(JSVariants.TROPICAL, 8157495, 11238957));
    public static final JSGene TUNDRA_COSMETIC = JSGenetics.register(JSCommon.createId("tundra"), new JSCosmeticGene(JSVariants.TUNDRA, 0xB7B7B7, 0xFFFFFF));
    public static final JSGene ARID_COSMETIC = JSGenetics.register(JSCommon.createId("arid"), new JSCosmeticGene(JSVariants.ARID, 6308112, 16286504));
    public static final JSGene CHAOS_EFFECT_COSMETIC = JSGenetics.register(JSCommon.createId("chaos_effect"), new JSCosmeticGene(JSVariants.CHAOS_EFFECT, 13874244, 11612211));
    public static final JSGene SPECIAL_COSMETIC = JSGenetics.register(JSCommon.createId("special"), new JSCosmeticGene(JSVariants.SPECIAL, 0x161616, 12136182));
    public static final JSGene LUX = JSGenetics.register(JSCommon.createId("lux"), new JSGene());
    public static final JSGene TOXIC_SKIN = JSGenetics.register(JSCommon.createId("toxic_skin"), new JSToxicSkinGene());
    public static final JSGene VENOM_BITE = JSGenetics.register(JSCommon.createId("venomous_bite"), new JSVenomBiteGene());
    public static final JSGene AGGRESSIVE_INSTINCT = JSGenetics.register(JSCommon.createId("aggresive_instinct"), new JSAggressiveInstinct());
    public static final JSGene BONE_DENSITY = JSGenetics.register(JSCommon.createId("bone_density"), new JSBoneDensity());
    public static final JSGene TOOTH_HARDNESS = JSGenetics.register(JSCommon.createId("tooth_hardness"), new JSToothHardness());
    public static final JSGene SKIN_TOUGHNESS = JSGenetics.register(JSCommon.createId("skin_toughness"), new JSSkinToughness());
    public static final JSGene LIGHT_SKELETON = JSGenetics.register(JSCommon.createId("lightweight_skeleton"), new JSLightSkeleton());
    public static final JSGene INTENSIVE_REPAIR = JSGenetics.register(JSCommon.createId("intensive_repair"), new JSIntensiveRepair());
    public static final JSGene IMMUNE_RESPONSE = JSGenetics.register(JSCommon.createId("immune_response"), new JSGene());
    public static final JSGene SIZE_SMALL = JSGenetics.register(JSCommon.createId("size_small"), new JSSizeGene(-0.1f, false));
    public static final JSGene SIZE_LARGE = JSGenetics.register(JSCommon.createId("size_large"), new JSSizeGene(0.1f, true));
    public static final JSGene GENDER_LEAN_FEMALE = JSGenetics.register(JSCommon.createId("gender_lean_female"), new JSGenderLeanGene(false));
    public static final JSGene GENDER_LEAN_MALE = JSGenetics.register(JSCommon.createId("gender_lean_male"), new JSGenderLeanGene(true));
    public static final JSGene INFERTILITY = JSGenetics.register(JSCommon.createId("infertility"), new JSInfertilityGene());
    public static final JSGene LYSINE_DEFICIENCY = JSGenetics.register(JSCommon.createId("lysine_deficiency"), new JSGene());
    public static final JSGene FREQ_OVULATION = JSGenetics.register(JSCommon.createId("freq_ovulation"), new JSGene());
    public static final JSGene PARENTAL_INVESTMENT = JSGenetics.register(JSCommon.createId("parental_investment"), new JSGene());

    public static void init() {
        DEFAULT_GENES.add(SIZE_LARGE);
        DEFAULT_GENES.add(SIZE_SMALL);
        DEFAULT_GENES.add(VENOM_BITE);
        DEFAULT_GENES.add(TOXIC_SKIN);
        DEFAULT_GENES.add(BONE_DENSITY);
        DEFAULT_GENES.add(TOOTH_HARDNESS);
        DEFAULT_GENES.add(SKIN_TOUGHNESS);
        DEFAULT_GENES.add(AGGRESSIVE_INSTINCT);
        DEFAULT_GENES.add(IMMUNE_RESPONSE);
        DEFAULT_GENES.add(INTENSIVE_REPAIR);
        DEFAULT_GENES.add(LIGHT_SKELETON);
        DEFAULT_GENES.add(GENDER_LEAN_FEMALE);
        DEFAULT_GENES.add(GENDER_LEAN_MALE);
        DEFAULT_GENES.add(INFERTILITY);
        JSGenetics.setDefault(EntityType.ALLAY, AnimalType.FANTASY, AGGRESSIVE_INSTINCT);
        JSGenetics.setDefault(EntityType.ARMADILLO, AnimalType.MAMMAL, SKIN_TOUGHNESS);
        JSGenetics.setDefault(EntityType.CAMEL, AnimalType.MAMMAL, ARID_COSMETIC);
        JSGenetics.setDefault(EntityType.COW, AnimalType.MAMMAL, PASTURE_COSMETIC);
        JSGenetics.setDefault(EntityType.DOLPHIN, AnimalType.AQUATIC_MAMMAL, OCEAN_COSMETIC);
        JSGenetics.setDefault(EntityType.ENDERMAN, AnimalType.FANTASY, LIGHT_SKELETON);
        JSGenetics.setDefault(EntityType.FOX, AnimalType.MAMMAL, TAIGA_COSMETIC);
        JSGenetics.setDefault(EntityType.GLOW_SQUID, AnimalType.FISH, LUX);
        JSGenetics.setDefault(EntityType.GOAT, AnimalType.MAMMAL, ALPINE_COSMETIC);
        JSGenetics.setDefault(EntityType.LLAMA, AnimalType.MAMMAL, LYSINE_DEFICIENCY, STEPPE_COSMETIC);
        JSGenetics.setDefault(EntityType.PANDA, AnimalType.MAMMAL, PARENTAL_INVESTMENT);
        JSGenetics.setDefault(EntityType.PARROT, AnimalType.MAMMAL, RAINFOREST_COSMETIC);
        JSGenetics.setDefault(EntityType.POLAR_BEAR, AnimalType.MAMMAL, TUNDRA_COSMETIC);
        JSGenetics.setDefault(EntityType.RABBIT, AnimalType.MAMMAL, FREQ_OVULATION, FOREST_COSMETIC);
        JSGenetics.setDefault(EntityType.RAVAGER, AnimalType.FANTASY, SIZE_LARGE);
        JSGenetics.setDefault(EntityType.SALMON, AnimalType.FISH, RIVER_COSMETIC);
        JSGenetics.setDefault(EntityType.SILVERFISH, AnimalType.FANTASY, SIZE_SMALL);
        JSGenetics.setDefault(EntityType.SKELETON, AnimalType.FANTASY, BONE_DENSITY);
        JSGenetics.setDefault(EntityType.SNIFFER, AnimalType.FANTASY, INTENSIVE_REPAIR);
        JSGenetics.setDefault(EntityType.SNOW_GOLEM, AnimalType.FANTASY, IMMUNE_RESPONSE);
        JSGenetics.setDefault(EntityType.WOLF, AnimalType.MAMMAL, TOOTH_HARDNESS);
        JSGenetics.setDefault(EntityType.FROG, AnimalType.MAMMAL, GENDER_LEAN_FEMALE);
        JSGenetics.setDefault(EntityType.COD, AnimalType.MAMMAL, GENDER_LEAN_MALE);
        JSGenetics.addPlantGene("alethopteris", JSV1Blocks.ALETHOPTERIS, Era.CARBONIFEROUS, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CRETACEOUS);
        JSGenetics.addPlantGene("cobbania_corrugata", JSV1Blocks.COBANNIA_CORRUGATA, Era.CRETACEOUS);
        JSGenetics.addPlantGene("cycadeoidea", JSV1Blocks.CYCADEOIDEA, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CRETACEOUS);
        JSGenetics.addPlantGene("neocalamites", JSV1Blocks.NEOCALAMITES, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CRETACEOUS);
        JSGenetics.addPlantGene("omphalophloios", JSV1Blocks.OMPHALOPHLOIOS, Era.CARBONIFEROUS);
        JSGenetics.addPlantGene("rhamnus_salicifolius", JSV1Blocks.RHAMNUS_SALICIFOLIUS, Era.CRETACEOUS);
        JSGenetics.addPlantGene("selaginellites", JSV1Blocks.SELAGINELLITES, Era.CRETACEOUS);
        JSGenetics.addPlantGene("veriformans", JSV1Blocks.VERIFORMANS, Era.CRETACEOUS);
        JSGenetics.addPlantGene("tempskya", JSV1Blocks.TEMPSKYA, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_basic", JSV1Blocks.ZINGIBEROPSIS_BASIC, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_orange", JSV1Blocks.ZINGIBEROPSIS_ORANGE, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_pink", JSV1Blocks.ZINGIBEROPSIS_PINK, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_red", JSV1Blocks.ZINGIBEROPSIS_RED, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_white", JSV1Blocks.ZINGIBEROPSIS_WHITE, Era.CRETACEOUS);
        JSGenetics.addPlantGene("zingiberopsis_yellow", JSV1Blocks.ZINGIBEROPSIS_YELLOW, Era.CRETACEOUS);
        JSGenetics.addPlantGene("caprina", JSV1Blocks.CAPRINA, Era.CRETACEOUS);
        JSGenetics.addPlantGene("hippuritella", JSV1Blocks.HIPPURITELLA, Era.CRETACEOUS);
        JSGenetics.addPlantGene("cremnoceramus", JSV1Blocks.CREMNOCERAMUS, Era.CRETACEOUS);
        JSGenetics.addPlantGene("inoceramus", JSV1Blocks.INOCERAMUS, Era.CRETACEOUS, Era.JURASSIC);
        JSGenetics.addPlantGene("lepidodendron_sapling", JSV1Blocks.LEPIDODENDRON_SAPLING, Era.CARBONIFEROUS, Era.PERMIAN, Era.TRIASSIC);
        JSGenetics.addPlantGene("spinifructus_sapling", JSV1Blocks.SPINIFRUCTUS_SAPLING, Era.CRETACEOUS);
        JSGenetics.addPlantGene("araucarioxylon_sapling", JSV1Blocks.ARAUCARIOXYLON_SAPLING, Era.CARBONIFEROUS, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CARBONIFEROUS, Era.PALEOGENE);
        JSGenetics.addPlantGene("gordonopteris_sapling", JSV1Blocks.GORDONPTERIS_SAPLING, Era.TRIASSIC);
        JSGenetics.addPlantGene("brasenites_kansense_basic", JSV2Blocks.BRASENITES_KANSENSE_BASIC, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_blue", JSV2Blocks.BRASENITES_KANSENSE_BLUE, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_lightblue", JSV2Blocks.BRASENITES_KANSENSE_LIGHTBLUE, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_magenta", JSV2Blocks.BRASENITES_KANSENSE_MAGENTA, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_orange", JSV2Blocks.BRASENITES_KANSENSE_ORANGE, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_pink", JSV2Blocks.BRASENITES_KANSENSE_PINK, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_red", JSV2Blocks.BRASENITES_KANSENSE_RED, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("brasenites_kansense_yellow", JSV2Blocks.BRASENITES_KANSENSE_YELLOW, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("montsechia", JSV2Blocks.MONTSECHIA, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("nathorstiana", JSV2Blocks.NATHORSTIANA, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("orontium_mackii", JSV2Blocks.ORONTIUM_MACKII, 2.0f, Era.CRETACEOUS);
        JSGenetics.addPlantGene("dicksonia", JSV2Blocks.DICKSONIA, 2.0f, Era.PERMIAN, Era.TRIASSIC, Era.JURASSIC, Era.CRETACEOUS, Era.PALEOGENE, Era.NEOGENE, Era.QUATERNARY);
        JSGenetics.addPlantGene("dicroidium", JSV2Blocks.DICROIDIUM, 2.0f, Era.TRIASSIC);
        JSGenetics.addPlantGene("zamites", JSV2Blocks.ZAMITES, 2.0f, Era.TRIASSIC);
        JSGenetics.addPlantGene("williamsonia", JSV2Blocks.WILLIAMSONIA, 2.0f, Era.TRIASSIC);
        JSGenetics.addPlantGene("gondwanagaricites", JSV2Blocks.GONDWANAGARICITES, 2.0f, Era.TRIASSIC);
        JSGenetics.addPlantGene("pleuromeia", JSV2Blocks.PLEUROMEIA, 2.0f, Era.TRIASSIC);
    }

    private static void addPlantGene(String plantCode, Supplier<Block> completionResult, Era ... eras) {
        JSGeneData geneData = new JSGeneData();
        if (plantCode.contains(":")) {
            geneData.setDataOwnerName(plantCode);
        } else {
            geneData.setDataOwnerName("jurassicsaga:" + plantCode);
        }
        geneData.setBaseQuality(100);
        geneData.setGeneType(GeneType.PLANT);
        PLANT_GENETIC_INFORMATION.put(plantCode, new JSPlantData(JSItems.registerItem(plantCode + "_coin", (Supplier<Item>)((Supplier)() -> new PlantDnaItem(plantCode, geneData))), completionResult, eras));
    }

    private static void addPlantGene(String plantCode, Supplier<Block> completionResult, float version, Era ... eras) {
        JSGeneData geneData = new JSGeneData();
        if (plantCode.contains(":")) {
            geneData.setDataOwnerName(plantCode);
        } else {
            geneData.setDataOwnerName("jurassicsaga:" + plantCode);
        }
        geneData.setBaseQuality(100);
        geneData.setGeneType(GeneType.PLANT);
        PLANT_GENETIC_INFORMATION.put(plantCode, new JSPlantData(JSItems.registerItem(plantCode + "_coin", (Supplier<Item>)((Supplier)() -> new PlantDnaItem(plantCode, geneData))), completionResult, version, eras));
    }

    private static void setDefault(EntityType<?> type, AnimalType animalType, JSGene ... genes) {
        if (genes.length == 0 || type == null) {
            return;
        }
        JSGeneData geneData = new JSGeneData();
        ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey(type);
        geneData.setDataOwnerName(key.toString());
        geneData.setBaseQuality(100);
        geneData.addGenes(genes);
        ENTITY_DEFAULT_GENE_DATA.put(type, new JSDefaultEntityData(geneData, animalType, JSItems.registerItem(key.getPath() + "_default", (Supplier<Item>)((Supplier)() -> new OtherDnaItem(type, geneData, new Item.Properties())))));
    }

    public static <T extends JSGene> T register(ResourceLocation location, T gene) {
        gene.setRegisteredLocation(location);
        GENE_REGISTRY.put(location, gene);
        GENE_ITEMS.put(gene, JSItems.registerItem(location.getPath(), (Supplier<Item>)((Supplier)() -> new GeneItem(gene, new Item.Properties()))));
        return gene;
    }

    public static JSGene getGene(ResourceLocation location) {
        return GENE_REGISTRY.get(location);
    }
}

