/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.gene.obj;

import java.util.Objects;
import java.util.Optional;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.GeneType;
import jp.jurassicsaga.server.base.generic.gene.obj.JSCosmeticGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneDataHolder;
import net.minecraft.nbt.CompoundTag;

public class JSGeneData {
    public final JSGeneDataHolder geneDataHolder = new JSGeneDataHolder();
    private GeneType geneType = GeneType.CREATURE;
    private int geneSeed = 0;
    private float sizeDimorphism = 0.0f;
    private String dataOwnerName = "";
    private String donorName = "";
    private int baseQuality = 0;
    private int donorQuality = 0;

    public boolean hasGene(JSGene gene) {
        return this.geneDataHolder.getGENE_SET().contains(gene);
    }

    public JSGeneData resetGenes() {
        this.geneDataHolder.getGENE_SET().clear();
        return this;
    }

    public JSGeneData copy() {
        JSGeneData data = new JSGeneData();
        data.geneDataHolder.getGENE_SET().addAll(this.geneDataHolder.getGENE_SET());
        data.geneSeed = this.geneSeed;
        data.sizeDimorphism = this.sizeDimorphism;
        data.dataOwnerName = this.dataOwnerName;
        data.donorName = this.donorName;
        data.baseQuality = this.baseQuality;
        data.donorQuality = this.donorQuality;
        return data;
    }

    public JSGeneData addGenes(JSGene ... genes) {
        for (JSGene gene : genes) {
            this.addGene(gene);
        }
        return this;
    }

    public JSGeneData addGene(JSGene gene) {
        if (this.canAddGene(gene) && gene.canAddTo(this.geneDataHolder.getGENE_SET())) {
            this.geneDataHolder.getGENE_SET().add(gene);
        }
        return this;
    }

    public boolean canAddGene(JSGene gene) {
        if (gene.canAddTo(this.geneDataHolder.getGENE_SET())) {
            int maxGenes = 8;
            return this.geneDataHolder.getGENE_SET().size() + 1 <= maxGenes;
        }
        return false;
    }

    public JSGeneData removeGenes(JSGene ... genes) {
        for (JSGene gene : genes) {
            this.removeGene(gene);
        }
        return this;
    }

    public JSGeneData removeGene(JSGene gene) {
        this.geneDataHolder.getGENE_SET().remove(gene);
        return this;
    }

    public boolean canMerge(JSGeneData other) {
        if (this.dataOwnerName.equalsIgnoreCase(other.dataOwnerName)) {
            return true;
        }
        return this.canAcceptDonor(other.dataOwnerName);
    }

    public JSGeneData combine(JSGeneData other) {
        block5: {
            block4: {
                if (!this.dataOwnerName.equalsIgnoreCase(other.dataOwnerName)) break block4;
                int combinedOwnerQuality = Math.min(100, this.baseQuality + other.baseQuality);
                int combinedDonorQuality = Math.min(100, this.donorQuality + other.donorQuality);
                this.baseQuality = combinedOwnerQuality;
                this.donorQuality = combinedDonorQuality;
                if (other.geneDataHolder.getGENE_SET().isEmpty()) break block5;
                for (JSGene gene : other.geneDataHolder.getGENE_SET()) {
                    this.addGene(gene);
                }
                break block5;
            }
            if (this.canAcceptDonor(other.dataOwnerName)) {
                this.donorQuality = Math.min(100, this.donorQuality + other.baseQuality);
                this.donorName = other.dataOwnerName;
                if (!other.geneDataHolder.getGENE_SET().isEmpty()) {
                    for (JSGene gene : other.geneDataHolder.getGENE_SET()) {
                        if (!this.canAddGene(gene)) continue;
                        this.addGene(gene);
                    }
                }
            }
        }
        return this;
    }

    private boolean canAcceptDonor(String donorName) {
        if (this.geneType == GeneType.PLANT) {
            return false;
        }
        return this.donorName.equalsIgnoreCase(donorName) || this.donorName.isEmpty();
    }

    public boolean hasDonor() {
        if (this.geneType != GeneType.CREATURE) {
            return false;
        }
        return this.donorQuality > 0;
    }

    public int getTotalCompletion() {
        return Math.min(100, this.baseQuality + this.donorQuality);
    }

    public void loadFromNbt(CompoundTag nbt) {
        this.geneDataHolder.loadFromNbt(nbt);
        this.baseQuality = nbt.getInt("js.genetic_data.quality.base");
        this.donorQuality = nbt.getInt("js.genetic_data.quality.donor.quality");
        this.geneSeed = nbt.getInt("js.genetic_data.seed");
        this.sizeDimorphism = nbt.getFloat("js.genetic_data.size_dimorphism");
        this.dataOwnerName = nbt.getString("js.genetic_data.name.base");
        this.donorName = nbt.getString("js.genetic_data.name.donor");
        this.geneType = GeneType.values()[nbt.getInt("js.genetics.type")];
    }

    public CompoundTag saveToNbt(CompoundTag nbt) {
        this.geneDataHolder.saveToNbt(nbt);
        nbt.putInt("js.genetic_data.quality.base", this.baseQuality);
        nbt.putInt("js.genetic_data.quality.donor.quality", this.donorQuality);
        nbt.putString("js.genetic_data.name.base", this.dataOwnerName);
        nbt.putString("js.genetic_data.name.donor", this.donorName);
        nbt.putInt("js.genetic_data.seed", this.geneSeed);
        nbt.putFloat("js.genetic_data.size_dimorphism", this.sizeDimorphism);
        nbt.putInt("js.genetics.type", this.geneType.ordinal());
        return nbt;
    }

    public boolean isValid() {
        return !this.dataOwnerName.isBlank() || this.baseQuality > 0;
    }

    public Optional<JSGene> getFirstCosmetic() {
        return this.geneDataHolder.getGENE_SET().stream().filter(JSCosmeticGene.class::isInstance).findFirst();
    }

    public JSVariants.JSVariant getVariant() {
        return this.getFirstCosmetic().map(g -> ((JSCosmeticGene)g).getVariant()).orElse(JSVariants.NONE);
    }

    public JSAnimal<?> getAnimal() {
        return JSAnimals.getAnimal(this.dataOwnerName);
    }

    public boolean hasData() {
        if (!this.geneDataHolder.getGENE_SET().isEmpty()) {
            return true;
        }
        if (this.baseQuality > 0) {
            return true;
        }
        return this.donorQuality > 0;
    }

    public boolean isCompatibleWith(String donorName) {
        return this.donorName.isEmpty() || donorName.equals(this.donorName);
    }

    public boolean canAccept(JSGene gene) {
        return gene.canAddTo(this.geneDataHolder.getGENE_SET());
    }

    public boolean isSameAs(JSGeneData coinData) {
        boolean hasSameDonor = Objects.equals(coinData.donorName, this.donorName);
        boolean hasSameName = Objects.equals(coinData.dataOwnerName, this.dataOwnerName);
        if (hasSameDonor && hasSameName) {
            boolean hasSameSeed = Objects.equals(coinData.geneSeed, this.geneSeed);
            boolean hasSameDimorphism = Objects.equals(Float.valueOf(coinData.sizeDimorphism), Float.valueOf(this.sizeDimorphism));
            boolean hasSameQuality = Objects.equals(coinData.getTotalCompletion(), this.getTotalCompletion());
            if (hasSameQuality && hasSameDimorphism && hasSameSeed) {
                return coinData.geneDataHolder.isSameAs(this.geneDataHolder);
            }
        }
        return false;
    }

    public void setGeneType(GeneType geneType) {
        this.geneType = geneType;
    }

    public GeneType getGeneType() {
        return this.geneType;
    }

    public int getGeneSeed() {
        return this.geneSeed;
    }

    public void setGeneSeed(int geneSeed) {
        this.geneSeed = geneSeed;
    }

    public float getSizeDimorphism() {
        return this.sizeDimorphism;
    }

    public void setSizeDimorphism(float sizeDimorphism) {
        this.sizeDimorphism = sizeDimorphism;
    }

    public String getDataOwnerName() {
        return this.dataOwnerName;
    }

    public void setDataOwnerName(String dataOwnerName) {
        this.dataOwnerName = dataOwnerName;
    }

    public String getDonorName() {
        return this.donorName;
    }

    public void setDonorName(String donorName) {
        this.donorName = donorName;
    }

    public int getBaseQuality() {
        return this.baseQuality;
    }

    public void setBaseQuality(int baseQuality) {
        this.baseQuality = baseQuality;
    }

    public int getDonorQuality() {
        return this.donorQuality;
    }

    public void setDonorQuality(int donorQuality) {
        this.donorQuality = donorQuality;
    }
}

