/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.gene.obj;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class JSGeneDataHolder {
    private final List<JSGene> GENE_SET = new ArrayList<JSGene>();

    public void loadFromNbt(CompoundTag nbt) {
        this.GENE_SET.clear();
        int size = nbt.getInt("js.genetic_data.size");
        if (size <= 0) {
            return;
        }
        for (int i = 1; i <= size; ++i) {
            JSGene gene;
            String geneString;
            String key = "js.genetic_data." + i;
            if (!nbt.contains(key, 8) || (geneString = nbt.getString(key)).isEmpty() || (gene = JSGenetics.getGene(ResourceLocation.tryParse((String)geneString))) == null) continue;
            this.GENE_SET.add(gene);
        }
    }

    public void saveToNbt(CompoundTag nbt) {
        int index = 1;
        for (JSGene gene : this.GENE_SET) {
            nbt.putString("js.genetic_data." + index, gene.getRegisteredLocation().toString());
            ++index;
        }
        nbt.putInt("js.genetic_data.size", this.GENE_SET.size());
    }

    public boolean isSameAs(JSGeneDataHolder geneDataHolder) {
        boolean hasSameSize = Objects.equals(this.GENE_SET.size(), geneDataHolder.GENE_SET.size());
        if (hasSameSize) {
            for (int i = 0; i < geneDataHolder.getGENE_SET().size(); ++i) {
                if (this.getGENE_SET().get(i).equals(geneDataHolder.getGENE_SET().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<JSGene> getGENE_SET() {
        return this.GENE_SET;
    }
}

