/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.util;

import java.util.List;
import jp.jurassicsaga.JSCommon;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JSUtils {
    public static final int INGEN_CYAN = 11400703;
    public static final int INGEN_GREEN = 6980223;

    public static VoxelShape rotateShape(VoxelShape shape, Rotation rotation) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            AABB rotatedAABB = JSUtils.rotateAABB(new AABB(x1, y1, z1, x2, y2, z2), rotation);
            buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((AABB)rotatedAABB));
        });
        return buffer[1];
    }

    private static AABB rotateAABB(AABB box, Rotation rotation) {
        double x1 = box.minX;
        double y1 = box.minY;
        double z1 = box.minZ;
        double x2 = box.maxX;
        double y2 = box.maxY;
        double z2 = box.maxZ;
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new AABB(1.0 - z2, y1, x1, 1.0 - z1, y2, x2);
            case Rotation.CLOCKWISE_180 -> new AABB(1.0 - x2, y1, 1.0 - z2, 1.0 - x1, y2, 1.0 - z1);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(z1, y1, 1.0 - x2, z2, y2, 1.0 - x1);
            default -> box;
        };
    }

    public static ChatFormatting getQualityColor(int quality) {
        if (quality < 25) {
            return ChatFormatting.RED;
        }
        if (quality < 50) {
            return ChatFormatting.YELLOW;
        }
        if (quality < 90) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.GREEN;
    }

    public static float toTickSeconds(float seconds) {
        return seconds * 20.0f;
    }

    public static float toTickMinutes(float minutes) {
        return minutes * 60.0f * 20.0f;
    }

    public static float toTickHours(float hours) {
        return hours * 60.0f * 60.0f * 20.0f;
    }

    public static float toTicksMCDays(float days) {
        return days * JSUtils.toTickMinutes(20.0f);
    }

    public static float toMinutesTicks(int ticks) {
        return (float)ticks / 1200.0f;
    }

    public static double kmhToSpeed(double kmh) {
        return kmh / 72.0;
    }

    public static boolean onShiftTooltip(TooltipFlag tooltipFlag, List<Component> tooltipComponents) {
        if (!tooltipFlag.isAdvanced() && JSCommon.isShiftKeyDown) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.shift_hint").withStyle(ChatFormatting.BLUE));
            return false;
        }
        return true;
    }

    public static boolean isWithinDistanceSqr(Vec3 from, Vec3 to, double blocks) {
        double canDistance;
        double distance = from.distanceToSqr(to);
        return distance < (canDistance = blocks * blocks);
    }

    public static boolean isWithinDistanceSqr(Entity targetEntity, Vec3 position, double blocks) {
        double canDistance;
        double distance = targetEntity.distanceToSqr(position);
        return distance < (canDistance = blocks * blocks);
    }

    public static boolean isTimeBetween(long time, long start, long end) {
        time %= 24000L;
        if ((start %= 24000L) <= (end %= 24000L)) {
            return time >= start && time <= end;
        }
        return time >= start || time <= end;
    }

    public static int getLightAtPos(@NotNull Level level, @NotNull BlockPos pos) {
        float brightnessSky = level.getBrightness(LightLayer.SKY, pos);
        float brightnessGround = level.getBrightness(LightLayer.BLOCK, pos);
        float blockLight = Math.min(15.0f, brightnessGround + brightnessSky);
        return (int)blockLight;
    }
}

