/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersItems;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSDefaultEntityData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSPlantData;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneItem;
import jp.jurassicsaga.server.util.JSHelper;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import travelers.server.animal.obj.TravelersItemInterface;
import travelers.util.helper.TravelersRegistry;

public class JSItemGroups {
    public static final TravelersRegistry<CreativeModeTab> TABS = new TravelersRegistry(BuiltInRegistries.CREATIVE_MODE_TAB, "jurassicsaga");
    public static final Supplier<CreativeModeTab> ITEMS = TABS.register("js.items", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.items"), JSV1Items.PADDOCK_SIGN, (version, output) -> {
        ArrayList<TravelersItemInterface> ITEM_ARRAY = new ArrayList<TravelersItemInterface>();
        ArrayList<TravelersItemInterface> EXTINCT_ITEM_ARRAY = new ArrayList<TravelersItemInterface>();
        for (JSAnimal<?> jSAnimal : JSAnimals.getAnimals()) {
            if (version != -1.0f && jSAnimal.getAnimalAttributes().getMiscProperties().getVersion() != version) continue;
            if (jSAnimal.getAnimalAttributes().getMiscProperties().isExtinct()) {
                EXTINCT_ITEM_ARRAY.add(jSAnimal.getItems());
            }
            ITEM_ARRAY.add(jSAnimal.getItems());
        }
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            if (version != -1.0f && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getHatched_egg() == null) continue;
            output.add(((Item)jSTravelersItems.getHatched_egg().get()).getDefaultInstance());
        }
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            if (version != -1.0f && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getBucket() == null) continue;
            output.add(((Item)jSTravelersItems.getBucket().get()).getDefaultInstance());
        }
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            if (version != -1.0f && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getCoin() == null) continue;
            output.add(((Item)jSTravelersItems.getCoin().get()).getDefaultInstance());
        }
        JSGenetics.ENTITY_DEFAULT_GENE_DATA.entrySet().stream().sorted(Comparator.comparing(a -> BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)a.getKey())).getPath())).forEach(entry -> {
            if (version == -1.0f) {
                output.add(((Item)((JSDefaultEntityData)entry.getValue()).coin().get()).getDefaultInstance());
            }
        });
        JSGenetics.PLANT_GENETIC_INFORMATION.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            if (version == -1.0f || version == ((JSPlantData)entry.getValue()).version) {
                output.add(((Item)((JSPlantData)entry.getValue()).coin.get()).getDefaultInstance());
            }
        });
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            if (version != -1.0f && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getCookedMeat() == null) continue;
            output.add(((Item)jSTravelersItems.getCookedMeat().get()).getDefaultInstance());
            output.add(((Item)jSTravelersItems.getRawMeat().get()).getDefaultInstance());
        }
        for (JSTravelersItems jSTravelersItems : EXTINCT_ITEM_ARRAY) {
            if (version != -1.0f && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getFossil_remains() == null) continue;
            output.add(((Item)jSTravelersItems.getFossil_remains().get()).getDefaultInstance());
        }
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            if (version != -1.0f && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version) continue;
            jSTravelersItems.getCustom_items().forEach((droppableItem, itemDeferredItem) -> output.add(((Item)itemDeferredItem.get()).getDefaultInstance()));
        }
        if (version == -1.0f) {
            for (Iterator<JSAnimal<Object>> iterator : Era.values()) {
                ((Era)((Object)((Object)((Object)iterator)))).getRegistryMap().forEach((result, itemDeferredItem) -> output.add(((Item)itemDeferredItem.get()).getDefaultInstance()));
            }
            output.add(((Item)JSItems.GUIDEBOOK.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.CLICKER.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.KEYCARD.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.EMPTY_TEST_TUBE.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.SYRINGE.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.RED_EYED_TREE_FROG.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.REED_FROG.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.MOSQUITO.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.SQUID.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.SQUID_COOKED.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.PADDOCK_SIGN.get()).getDefaultInstance());
        }
        if (version == -1.0f || version == 1.0f) {
            output.add(((Item)JSV1Items.ALLIGATOR_EGG.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.FISH_EGG.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.OSTRICH_EGG.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.FROG_EGG.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.BASILISK_EGG.get()).getDefaultInstance());
            output.add(((Item)JSV1Items.SPIDER_EGG.get()).getDefaultInstance());
        }
        return output;
    }));
    public static final Supplier<CreativeModeTab> BLOCKS = TABS.register("js.blocks", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.blocks"), (Supplier<Item>)((Supplier)() -> ((Block)JSV1Blocks.BIG_TILE.get()).asItem()), (version, output) -> {
        HashSet added = new HashSet();
        Consumer<ItemLike> safeOutput = item -> {
            if (added.add(item)) {
                output.add(item.asItem().getDefaultInstance());
            }
        };
        if (version == -1.0f || (double)version == 1.0) {
            JSV1Blocks.addBlocks(safeOutput).run();
        }
        if (version == -1.0f || (double)version == 2.0) {
            JSV2Blocks.addBlocks(safeOutput).run();
        }
        return output;
    }));
    public static final Supplier<CreativeModeTab> PLANTS = TABS.register("js.plants", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.plants"), (Supplier<Item>)((Supplier)() -> ((Block)JSV1Blocks.SWISS_CHEESE_PLANT.get()).asItem()), (version, output) -> {
        HashSet added = new HashSet();
        Consumer<ItemLike> safeOutput = item -> {
            if (added.add(item)) {
                output.add(item.asItem().getDefaultInstance());
            }
        };
        if (version == -1.0f || (double)version == 1.0) {
            JSV1Blocks.addPlants(safeOutput).run();
        }
        if (version == -1.0f || (double)version == 2.0) {
            JSV2Blocks.addPlants(safeOutput).run();
        }
        return output;
    }));
    public static final Supplier<CreativeModeTab> GENETICS = TABS.register("js.genetics", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.genetics"), (Supplier<Item>)((Supplier)() -> (Item)JSGenetics.GENE_ITEMS.get(JSGenetics.LUX).get()), (version, output) -> {
        if (version == -1.0f || (double)version == 1.0) {
            JSGenetics.GENE_ITEMS.values().stream().map(Supplier::get).sorted(Comparator.comparing(a -> BuiltInRegistries.ITEM.getKey(a).getPath())).forEach(o -> {
                if (o instanceof GeneItem) {
                    GeneItem geneItem = (GeneItem)((Object)((Object)((Object)o)));
                    if (version == -1.0f || geneItem.getGene().getVersionAdded() == version) {
                        output.add(o.getDefaultInstance());
                    }
                }
            });
        }
        return output;
    }));
    public static final Supplier<CreativeModeTab> SPAWN_EGGS = TABS.register("js.spawn_eggs", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.spawn_eggs"), (Supplier<Item>)((Supplier)() -> (Item)JSV1Animals.VELOCIRAPTOR.getItems().getSpawnEgg().get()), (version, output) -> {
        JSAnimals.getAnimals().stream().sorted(Comparator.comparingDouble(a -> a.getAnimalAttributes().getMiscProperties().getVersion())).filter(a -> version == -1.0f || a.getAnimalAttributes().getMiscProperties().getVersion() == version).map(a -> ((Item)a.getItems().getSpawnEgg().get()).getDefaultInstance()).forEach(output::add);
        return output;
    }));

    public static void init() {
    }
}

