/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.egg;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.egg.EggEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class HatchedEgg
extends SpawnEggItem {
    private static final List<HatchedEgg> MOD_EGGS = new ArrayList<HatchedEgg>();
    private final Supplier<? extends EntityType<? extends EggEntity>> typeSupplier;
    private final JSGeneData data;
    private final Random rng = new Random();

    public HatchedEgg(JSGeneData data) {
        super((EntityType)JSEntities.EGG.get(), 0xFFFFFF, 0xFFFFFF, new Item.Properties());
        this.typeSupplier = () -> (EntityType)JSEntities.EGG.get();
        this.data = data;
        MOD_EGGS.add(this);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = pContext.getItemInHand();
        BlockPos blockpos = pContext.getClickedPos();
        Direction direction = pContext.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos blockpos1 = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        EntityType<? extends EggEntity> entitytype = this.typeSupplier.get();
        EggEntity mob = new EggEntity(entitytype, level);
        mob.moveTo(blockpos1.getCenter().x + (double)(this.rng.nextFloat() / 2.0f), blockpos1.getY(), blockpos1.getCenter().z + (double)(this.rng.nextFloat() / 2.0f));
        JSGeneData data = JSGeneUtil.readFromStack(itemstack);
        data = this.data.copy().combine(data);
        mob.setData(data);
        itemstack.shrink(1);
        level.gameEvent((Entity)pContext.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        level.addFreshEntity((Entity)mob);
        mob.refreshDimensions();
        return InteractionResult.CONSUME;
    }

    @NotNull
    public Optional<Mob> spawnOffspringFromSpawnEgg(@NotNull Player pPlayer, @NotNull Mob pMob, @NotNull EntityType<? extends Mob> pEntityType, @NotNull ServerLevel pServerLevel, @NotNull Vec3 pPos, @NotNull ItemStack pStack) {
        if (!this.spawnsEntity(pStack, pEntityType)) {
            return Optional.empty();
        }
        EntityType<? extends EggEntity> entitytype = this.typeSupplier.get();
        EggEntity mob = new EggEntity(entitytype, (Level)pServerLevel);
        mob.moveTo(pPos.x(), pPos.y(), pPos.z(), 0.0f, 0.0f);
        JSGeneData data = JSGeneUtil.readFromStack(pStack);
        data.combine(this.data);
        mob.setData(data);
        pStack.consume(1, (LivingEntity)pPlayer);
        return Optional.of(mob);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        BlockHitResult blockhitresult = HatchedEgg.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (!(pLevel instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        if (!(pLevel.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (pLevel.mayInteract(pPlayer, blockpos) && pPlayer.mayUseItemAt(blockpos, blockhitresult.getDirection(), itemstack)) {
            EntityType<? extends EggEntity> entitytype = this.typeSupplier.get();
            EggEntity mob = new EggEntity(entitytype, pLevel);
            mob.moveTo(blockpos.getCenter().x + (double)(this.rng.nextFloat() / 2.0f), blockpos.getY(), blockpos.getCenter().z + (double)(this.rng.nextFloat() / 2.0f));
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            data.combine(this.data);
            mob.setData(data);
            itemstack.shrink(1);
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.ENTITY_PLACE, blockpos);
            pLevel.addFreshEntity((Entity)mob);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (stack.isEmpty()) {
            return;
        }
        JSGeneData data = JSGeneUtil.readFromStack(stack);
        if (JSUtils.onShiftTooltip(tooltipFlag, tooltipComponents)) {
            if (data.getBaseQuality() > 0) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.species").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)("entity." + data.getDataOwnerName().replace(':', '.'))).withStyle(ChatFormatting.YELLOW)));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.dna_quality").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(data.getBaseQuality() + "%")).withStyle(data.getBaseQuality() < 90 ? (data.getBaseQuality() < 50 ? (data.getBaseQuality() < 25 ? ChatFormatting.RED : ChatFormatting.YELLOW) : ChatFormatting.GOLD) : ChatFormatting.GREEN)));
            }
            if (data.hasDonor()) {
                tooltipComponents.add((Component)Component.empty());
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.donor_info"));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.species").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)("entity." + data.getDonorName().replace(":", "."))).withStyle(ChatFormatting.YELLOW)));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.dna_quality").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(data.getDonorQuality() + "%")).withStyle(data.getDonorQuality() < 90 ? (data.getDonorQuality() < 50 ? (data.getDonorQuality() < 25 ? ChatFormatting.RED : ChatFormatting.YELLOW) : ChatFormatting.GOLD) : ChatFormatting.GREEN)));
            }
            if (data.getTotalCompletion() == 100) {
                if (stack.has((DataComponentType)JSDataComponents.GENE_EXTRACTOR_TRIES.get()) && !data.geneDataHolder.getGENE_SET().isEmpty()) {
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.extractions_remaining", (Object[])new Object[]{stack.get((DataComponentType)JSDataComponents.GENE_EXTRACTOR_TRIES.get())}).withStyle(ChatFormatting.GRAY));
                }
                if (!data.geneDataHolder.getGENE_SET().isEmpty()) {
                    tooltipComponents.add((Component)Component.empty());
                    tooltipComponents.add((Component)Component.literal((String)"Genes:"));
                    int i = 0;
                    for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
                        tooltipComponents.add((Component)Component.literal((String)(++i + ". ")).append((Component)gene.getTranslatableObject()).withStyle(gene.getToolTipColour()));
                    }
                }
            }
        }
    }
}

