/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.entity;

import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.other.PaddockSignEntity;
import jp.jurassicsaga.server.base.generic.networking.obj.OpenGui;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import travelers.util.helper.TravelersPacketDistributor;

public class PaddockSignItem
extends Item {
    public PaddockSignItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos blockpos = pContext.getClickedPos();
        Direction direction = pContext.getClickedFace();
        BlockPos blockpos1 = blockpos.relative(direction);
        Player player = pContext.getPlayer();
        ItemStack itemstack = pContext.getItemInHand();
        if (player != null && !this.mayPlace(player, direction, itemstack, blockpos1)) {
            return InteractionResult.FAIL;
        }
        Level level = pContext.getLevel();
        PaddockSignEntity entity = new PaddockSignEntity((EntityType<? extends HangingEntity>)((EntityType)JSEntities.PADDOCK_SIGN.get()), level, blockpos1);
        entity.setDirection(direction);
        entity.setAnimal(JSV1Animals.VELOCIRAPTOR);
        CustomData customdata = (CustomData)itemstack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!customdata.isEmpty()) {
            EntityType.updateCustomEntityTag((Level)level, (Player)player, (Entity)entity, (CustomData)customdata);
        }
        if (entity.survives()) {
            if (!level.isClientSide) {
                entity.playPlacementSound();
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
                if (level.addFreshEntity((Entity)entity) && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    TravelersPacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenGui(level.dimension().location(), "paddock_screen", entity.getId()));
                }
            }
            itemstack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player pPlayer, Direction pDirection, ItemStack pHangingEntityStack, BlockPos pPos) {
        return !pDirection.getAxis().isVertical() && pPlayer.mayUseItemAt(pPos, pDirection, pHangingEntityStack);
    }
}

