/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.world.biome;

import jp.jurassicsaga.JSCommon;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class JSBiome {
    private final String biomeName;
    private final ResourceKey<Biome> biomeKey;
    protected boolean hasRain = true;
    protected float temperature = 0.0f;
    protected float downfall = 0.9f;
    protected int waterColor = 50175;
    protected int waterFogColor = 28046;
    protected Integer grassColor = null;
    protected Integer foliageColor = null;
    protected Holder.Reference<SoundEvent> music = SoundEvents.MUSIC_BIOME_SNOWY_SLOPES;

    public JSBiome(String biomeName) {
        this.biomeName = biomeName;
        this.biomeKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)JSCommon.createId(biomeName));
    }

    protected SurfaceRules.ConditionSource surfaceNoiseAbove(double value) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(value / 8.25), (double)Double.MAX_VALUE);
    }

    public final Biome create(BootstrapContext<Biome> ctx) {
        MobSpawnSettings.Builder spawner = new MobSpawnSettings.Builder();
        this.addSpawns(ctx, spawner);
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(ctx.lookup(Registries.PLACED_FEATURE), ctx.lookup(Registries.CONFIGURED_CARVER));
        this.addSettings(ctx, builder);
        Biome.BiomeBuilder biomeBuilder = this.biome(this.hasRain, this.temperature, this.downfall, this.waterColor, this.waterFogColor, this.grassColor, this.foliageColor, spawner, builder, Musics.createGameMusic(this.music));
        this.applyExtraSettings(biomeBuilder);
        return biomeBuilder.build();
    }

    protected void applyExtraSettings(Biome.BiomeBuilder biomeBuilder) {
    }

    protected void addSettings(BootstrapContext<Biome> ctx, BiomeGenerationSettings.Builder builder) {
    }

    protected void addSpawns(BootstrapContext<Biome> ctx, MobSpawnSettings.Builder spawner) {
    }

    private Biome.BiomeBuilder biome(boolean pHasPrecipitation, float pTemperature, float pDownfall, int pWaterColor, int pWaterFogColor, Integer pGrassColorOverride, Integer pFoliageColorOverride, MobSpawnSettings.Builder pMobSpawnSettings, BiomeGenerationSettings.Builder pGenerationSettings, Music pBackgroundMusic) {
        BiomeSpecialEffects.Builder biomespecialeffects$builder = new BiomeSpecialEffects.Builder().waterColor(pWaterColor).waterFogColor(pWaterFogColor).fogColor(12638463).skyColor(this.calculateSkyColor(pTemperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(pBackgroundMusic);
        if (pGrassColorOverride != null) {
            biomespecialeffects$builder.grassColorOverride(pGrassColorOverride.intValue());
        }
        if (pFoliageColorOverride != null) {
            biomespecialeffects$builder.foliageColorOverride(pFoliageColorOverride.intValue());
        }
        return new Biome.BiomeBuilder().hasPrecipitation(pHasPrecipitation).temperature(pTemperature).downfall(pDownfall).specialEffects(biomespecialeffects$builder.build()).mobSpawnSettings(pMobSpawnSettings.build()).generationSettings(pGenerationSettings.build());
    }

    protected int calculateSkyColor(float pTemperature) {
        float $$1 = pTemperature / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    public final SurfaceRules.RuleSource sequence() {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{this.biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{this.innerSequence()}));
    }

    protected SurfaceRules.RuleSource innerSequence() {
        return SurfaceRules.state((BlockState)Blocks.STONE.defaultBlockState());
    }

    public String getBiomeName() {
        return this.biomeName;
    }

    public ResourceKey<Biome> getBiomeKey() {
        return this.biomeKey;
    }

    public boolean isHasRain() {
        return this.hasRain;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getDownfall() {
        return this.downfall;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public int getWaterFogColor() {
        return this.waterFogColor;
    }

    public Integer getGrassColor() {
        return this.grassColor;
    }

    public Integer getFoliageColor() {
        return this.foliageColor;
    }

    public Holder.Reference<SoundEvent> getMusic() {
        return this.music;
    }
}

