/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import jp.jurassicsaga.server.base.world.biome.JSBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;

public final class JSBiomeBuilder {
    private static final Climate.Parameter FULL_RANGE = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private static final Climate.Parameter[] TEMPS = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.45f), Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-0.15f, (float)0.2f), Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private static final Climate.Parameter[] HUMS = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)-0.35f, (float)-0.1f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.1f, (float)0.3f), Climate.Parameter.span((float)0.3f, (float)1.0f)};
    private static final Climate.Parameter[] EROS = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.78f), Climate.Parameter.span((float)-0.78f, (float)-0.375f), Climate.Parameter.span((float)-0.375f, (float)-0.2225f), Climate.Parameter.span((float)-0.2225f, (float)0.05f), Climate.Parameter.span((float)0.05f, (float)0.45f), Climate.Parameter.span((float)0.45f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private static final Climate.Parameter FROZEN_RANGE = TEMPS[0];
    private static final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.span((Climate.Parameter)TEMPS[1], (Climate.Parameter)TEMPS[4]);
    private static final Climate.Parameter MUSHROOM_C = Climate.Parameter.span((float)-1.2f, (float)-1.05f);
    private static final Climate.Parameter DEEP_OCEAN_C = Climate.Parameter.span((float)-1.05f, (float)-0.455f);
    private static final Climate.Parameter OCEAN_C = Climate.Parameter.span((float)-0.455f, (float)-0.19f);
    private static final Climate.Parameter COAST_C = Climate.Parameter.span((float)-0.19f, (float)-0.11f);
    private static final Climate.Parameter INLAND_C = Climate.Parameter.span((float)-0.11f, (float)0.55f);
    private static final Climate.Parameter NEAR_INLAND_C = Climate.Parameter.span((float)-0.11f, (float)0.03f);
    private static final Climate.Parameter MID_INLAND_C = Climate.Parameter.span((float)0.03f, (float)0.3f);
    private static final Climate.Parameter FAR_INLAND_C = Climate.Parameter.span((float)0.3f, (float)1.0f);
    private static final ResourceKey<Biome>[][] OCEANS = new ResourceKey[][]{{Biomes.DEEP_FROZEN_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.DEEP_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.WARM_OCEAN}, {Biomes.FROZEN_OCEAN, Biomes.COLD_OCEAN, Biomes.OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.WARM_OCEAN}};
    private static final ResourceKey<Biome>[][] MIDDLE = new ResourceKey[][]{{Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.TAIGA, Biomes.TAIGA}, {Biomes.PLAINS, Biomes.PLAINS, Biomes.FOREST, Biomes.TAIGA, Biomes.TAIGA}, {Biomes.FLOWER_FOREST, Biomes.PLAINS, Biomes.FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST}, {JSBiomes.SULPHUR_SPRINGS.getBiomeKey(), JSBiomes.SULPHUR_SPRINGS.getBiomeKey(), Biomes.FOREST, Biomes.JUNGLE, Biomes.JUNGLE}, {Biomes.DESERT, Biomes.DESERT, Biomes.DESERT, Biomes.DESERT, Biomes.DESERT}};
    private static final ResourceKey<Biome>[][] MIDDLE_VAR = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, Biomes.TAIGA, null, null}, {null, null, null, null, Biomes.TAIGA}, {Biomes.SUNFLOWER_PLAINS, null, null, Biomes.OLD_GROWTH_BIRCH_FOREST, null}, {null, null, Biomes.PLAINS, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}, {null, null, null, null, null}};
    private static final ResourceKey<Biome>[][] PLATEAU = new ResourceKey[][]{{Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_TAIGA, Biomes.SNOWY_TAIGA}, {Biomes.MEADOW, Biomes.MEADOW, Biomes.FOREST, Biomes.TAIGA, Biomes.TAIGA}, {Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.DARK_FOREST}, {Biomes.SAVANNA_PLATEAU, Biomes.SAVANNA_PLATEAU, Biomes.FOREST, Biomes.FOREST, Biomes.JUNGLE}, {Biomes.BADLANDS, Biomes.BADLANDS, Biomes.BADLANDS, Biomes.WOODED_BADLANDS, Biomes.WOODED_BADLANDS}};
    private static final ResourceKey<Biome>[][] PLATEAU_VAR = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, null, null, null}, {Biomes.CHERRY_GROVE, null, Biomes.MEADOW, Biomes.MEADOW, Biomes.TAIGA}, {Biomes.CHERRY_GROVE, Biomes.CHERRY_GROVE, Biomes.FOREST, Biomes.BIRCH_FOREST, null}, {null, null, null, null, null}, {Biomes.ERODED_BADLANDS, Biomes.ERODED_BADLANDS, null, null, null}};
    private static final ResourceKey<Biome>[][] SHATTERED = new ResourceKey[][]{{Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {null, null, null, null, null}, {null, null, null, null, null}};
    private final Map<ResourceKey<Biome>, WeightBag<ResourceKey<Biome>>> rarityPools = new HashMap<ResourceKey<Biome>, WeightBag<ResourceKey<Biome>>>();
    private long raritySalt = 0L;

    public JSBiomeBuilder setRaritySeed(long seed) {
        this.raritySalt = seed;
        return this;
    }

    public JSBiomeBuilder addVariant(ResourceKey<Biome> base, ResourceKey<Biome> variant, int weight) {
        if (weight <= 0) {
            return this;
        }
        this.rarityPools.computeIfAbsent(base, k -> new WeightBag()).add(base, 1).add(variant, weight);
        return this;
    }

    public List<Climate.ParameterPoint> spawnTarget() {
        Climate.Parameter y = Climate.Parameter.point((float)0.0f);
        float weirdCut = 0.16f;
        return List.of(new Climate.ParameterPoint(FULL_RANGE, FULL_RANGE, Climate.Parameter.span((Climate.Parameter)INLAND_C, (Climate.Parameter)FULL_RANGE), FULL_RANGE, y, Climate.Parameter.span((float)-1.0f, (float)(-weirdCut)), 0L), new Climate.ParameterPoint(FULL_RANGE, FULL_RANGE, Climate.Parameter.span((Climate.Parameter)INLAND_C, (Climate.Parameter)FULL_RANGE), FULL_RANGE, y, Climate.Parameter.span((float)weirdCut, (float)1.0f), 0L));
    }

    public void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out) {
        this.addOffCoastBiomes(out);
        this.addInlandBiomes(out);
        this.addUndergroundBiomes(out);
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out) {
        this.emitSurface(out, FULL_RANGE, FULL_RANGE, MUSHROOM_C, FULL_RANGE, FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS);
        for (int ti = 0; ti < TEMPS.length; ++ti) {
            Climate.Parameter t = TEMPS[ti];
            this.emitSurface(out, t, FULL_RANGE, DEEP_OCEAN_C, FULL_RANGE, FULL_RANGE, 0.0f, OCEANS[0][ti]);
            this.emitSurface(out, t, FULL_RANGE, OCEAN_C, FULL_RANGE, FULL_RANGE, 0.0f, OCEANS[1][ti]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out) {
        this.addMidSlice(out, Climate.Parameter.span((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(out, Climate.Parameter.span((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(out, Climate.Parameter.span((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(out, Climate.Parameter.span((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(out, Climate.Parameter.span((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(out, Climate.Parameter.span((float)-0.26666668f, (float)-0.05f));
        this.addValleys(out, Climate.Parameter.span((float)-0.05f, (float)0.05f));
        this.addLowSlice(out, Climate.Parameter.span((float)0.05f, (float)0.26666668f));
        this.addMidSlice(out, Climate.Parameter.span((float)0.26666668f, (float)0.4f));
        this.addHighSlice(out, Climate.Parameter.span((float)0.4f, (float)0.56666666f));
        this.addPeaks(out, Climate.Parameter.span((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(out, Climate.Parameter.span((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(out, Climate.Parameter.span((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out, Climate.Parameter d) {
        this.grid((ti, hi) -> {
            Climate.Parameter T = TEMPS[ti];
            Climate.Parameter H = HUMS[hi];
            ResourceKey<Biome> mid = this.pickMiddle(ti, hi, d);
            ResourceKey<Biome> midHot = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            ResourceKey<Biome> midHotOrSlopeCold = this.pickMiddleOrBadlandsIfHotOrSlopeIfCold(ti, hi, d);
            ResourceKey<Biome> plat = this.pickPlateau(ti, hi, d);
            ResourceKey<Biome> shat = this.pickShattered(ti, hi, d);
            ResourceKey<Biome> maybeSav = this.maybeWindsweptSavanna(ti, hi, d, shat);
            ResourceKey<Biome> peak = this.pickPeak(ti, hi, d);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)FAR_INLAND_C), EROS[0], d, 0.0f, peak);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)NEAR_INLAND_C), EROS[1], d, 0.0f, midHotOrSlopeCold);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[1], d, 0.0f, peak);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)NEAR_INLAND_C), Climate.Parameter.span((Climate.Parameter)EROS[2], (Climate.Parameter)EROS[3]), d, 0.0f, mid);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[2], d, 0.0f, plat);
            this.emitSurface(out, T, H, MID_INLAND_C, EROS[3], d, 0.0f, midHot);
            this.emitSurface(out, T, H, FAR_INLAND_C, EROS[3], d, 0.0f, plat);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)NEAR_INLAND_C), EROS[5], d, 0.0f, maybeSav);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[5], d, 0.0f, shat);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, mid);
        });
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out, Climate.Parameter d) {
        this.grid((ti, hi) -> {
            Climate.Parameter T = TEMPS[ti];
            Climate.Parameter H = HUMS[hi];
            ResourceKey<Biome> mid = this.pickMiddle(ti, hi, d);
            ResourceKey<Biome> midHot = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            ResourceKey<Biome> midHotOrSlopeCold = this.pickMiddleOrBadlandsIfHotOrSlopeIfCold(ti, hi, d);
            ResourceKey<Biome> plat = this.pickPlateau(ti, hi, d);
            ResourceKey<Biome> shat = this.pickShattered(ti, hi, d);
            ResourceKey<Biome> maybeSav = this.maybeWindsweptSavanna(ti, hi, d, mid);
            ResourceKey<Biome> slope = this.pickSlope(ti, hi, d);
            ResourceKey<Biome> peak = this.pickPeak(ti, hi, d);
            this.emitSurface(out, T, H, COAST_C, Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[1]), d, 0.0f, mid);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[0], d, 0.0f, slope);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[0], d, 0.0f, peak);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[1], d, 0.0f, midHotOrSlopeCold);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[1], d, 0.0f, slope);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)NEAR_INLAND_C), Climate.Parameter.span((Climate.Parameter)EROS[2], (Climate.Parameter)EROS[3]), d, 0.0f, mid);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[2], d, 0.0f, plat);
            this.emitSurface(out, T, H, MID_INLAND_C, EROS[3], d, 0.0f, midHot);
            this.emitSurface(out, T, H, FAR_INLAND_C, EROS[3], d, 0.0f, plat);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)NEAR_INLAND_C), EROS[5], d, 0.0f, maybeSav);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[5], d, 0.0f, shat);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, mid);
        });
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out, Climate.Parameter d) {
        this.emitSurface(out, FULL_RANGE, FULL_RANGE, COAST_C, Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[2]), d, 0.0f, (ResourceKey<Biome>)Biomes.STONY_SHORE);
        this.emitSurface(out, Climate.Parameter.span((Climate.Parameter)TEMPS[1], (Climate.Parameter)TEMPS[2]), FULL_RANGE, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, (ResourceKey<Biome>)Biomes.SWAMP);
        this.emitSurface(out, Climate.Parameter.span((Climate.Parameter)TEMPS[3], (Climate.Parameter)TEMPS[4]), FULL_RANGE, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, (ResourceKey<Biome>)Biomes.MANGROVE_SWAMP);
        this.grid((ti, hi) -> {
            Climate.Parameter T = TEMPS[ti];
            Climate.Parameter H = HUMS[hi];
            ResourceKey<Biome> mid = this.pickMiddle(ti, hi, d);
            ResourceKey<Biome> midHot = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            ResourceKey<Biome> midHotOrSlopeCold = this.pickMiddleOrBadlandsIfHotOrSlopeIfCold(ti, hi, d);
            ResourceKey<Biome> shat = this.pickShattered(ti, hi, d);
            ResourceKey<Biome> plat = this.pickPlateau(ti, hi, d);
            ResourceKey<Biome> beach = this.pickBeach(ti, hi);
            ResourceKey<Biome> maybeSav = this.maybeWindsweptSavanna(ti, hi, d, mid);
            ResourceKey<Biome> shCoast = this.pickShatteredCoast(ti, hi, d);
            ResourceKey<Biome> slope = this.pickSlope(ti, hi, d);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[0], d, 0.0f, slope);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)MID_INLAND_C), EROS[1], d, 0.0f, midHotOrSlopeCold);
            this.emitSurface(out, T, H, FAR_INLAND_C, EROS[1], d, 0.0f, ti == 0 ? slope : plat);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[2], d, 0.0f, mid);
            this.emitSurface(out, T, H, MID_INLAND_C, EROS[2], d, 0.0f, midHot);
            this.emitSurface(out, T, H, FAR_INLAND_C, EROS[2], d, 0.0f, plat);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)NEAR_INLAND_C), EROS[3], d, 0.0f, mid);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[3], d, 0.0f, midHot);
            if (d.max() < 0L) {
                this.emitSurface(out, T, H, COAST_C, EROS[4], d, 0.0f, beach);
                this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            } else {
                this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            }
            this.emitSurface(out, T, H, COAST_C, EROS[5], d, 0.0f, shCoast);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[5], d, 0.0f, maybeSav);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[5], d, 0.0f, shat);
            if (d.max() < 0L) {
                this.emitSurface(out, T, H, COAST_C, EROS[6], d, 0.0f, beach);
            } else {
                this.emitSurface(out, T, H, COAST_C, EROS[6], d, 0.0f, mid);
            }
            if (ti == 0) {
                this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, mid);
            }
        });
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out, Climate.Parameter d) {
        this.emitSurface(out, FULL_RANGE, FULL_RANGE, COAST_C, Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[2]), d, 0.0f, (ResourceKey<Biome>)Biomes.STONY_SHORE);
        this.emitSurface(out, Climate.Parameter.span((Climate.Parameter)TEMPS[1], (Climate.Parameter)TEMPS[2]), FULL_RANGE, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, (ResourceKey<Biome>)Biomes.SWAMP);
        this.emitSurface(out, Climate.Parameter.span((Climate.Parameter)TEMPS[3], (Climate.Parameter)TEMPS[4]), FULL_RANGE, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, (ResourceKey<Biome>)Biomes.MANGROVE_SWAMP);
        this.grid((ti, hi) -> {
            Climate.Parameter T = TEMPS[ti];
            Climate.Parameter H = HUMS[hi];
            ResourceKey<Biome> mid = this.pickMiddle(ti, hi, d);
            ResourceKey<Biome> midHot = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            ResourceKey<Biome> midHotOrSlopeCold = this.pickMiddleOrBadlandsIfHotOrSlopeIfCold(ti, hi, d);
            ResourceKey<Biome> beach = this.pickBeach(ti, hi);
            ResourceKey<Biome> maybeSav = this.maybeWindsweptSavanna(ti, hi, d, mid);
            ResourceKey<Biome> shCoast = this.pickShatteredCoast(ti, hi, d);
            this.emitSurface(out, T, H, NEAR_INLAND_C, Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[1]), d, 0.0f, midHot);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[1]), d, 0.0f, midHotOrSlopeCold);
            this.emitSurface(out, T, H, NEAR_INLAND_C, Climate.Parameter.span((Climate.Parameter)EROS[2], (Climate.Parameter)EROS[3]), d, 0.0f, mid);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), Climate.Parameter.span((Climate.Parameter)EROS[2], (Climate.Parameter)EROS[3]), d, 0.0f, midHot);
            this.emitSurface(out, T, H, COAST_C, Climate.Parameter.span((Climate.Parameter)EROS[3], (Climate.Parameter)EROS[4]), d, 0.0f, beach);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[4], d, 0.0f, mid);
            this.emitSurface(out, T, H, COAST_C, EROS[5], d, 0.0f, shCoast);
            this.emitSurface(out, T, H, NEAR_INLAND_C, EROS[5], d, 0.0f, maybeSav);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[5], d, 0.0f, mid);
            this.emitSurface(out, T, H, COAST_C, EROS[6], d, 0.0f, beach);
            if (ti == 0) {
                this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)NEAR_INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, mid);
            }
        });
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out, Climate.Parameter d) {
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, COAST_C, Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[1]), d, 0.0f, (ResourceKey<Biome>)(d.max() < 0L ? Biomes.STONY_SHORE : Biomes.FROZEN_RIVER));
        this.emitSurface(out, UNFROZEN_RANGE, FULL_RANGE, COAST_C, Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[1]), d, 0.0f, (ResourceKey<Biome>)(d.max() < 0L ? Biomes.STONY_SHORE : Biomes.RIVER));
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, NEAR_INLAND_C, Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[1]), d, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.emitSurface(out, UNFROZEN_RANGE, FULL_RANGE, NEAR_INLAND_C, Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[1]), d, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)FAR_INLAND_C), Climate.Parameter.span((Climate.Parameter)EROS[2], (Climate.Parameter)EROS[5]), d, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.emitSurface(out, UNFROZEN_RANGE, FULL_RANGE, Climate.Parameter.span((Climate.Parameter)COAST_C, (Climate.Parameter)FAR_INLAND_C), Climate.Parameter.span((Climate.Parameter)EROS[2], (Climate.Parameter)EROS[5]), d, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, COAST_C, EROS[6], d, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.emitSurface(out, UNFROZEN_RANGE, FULL_RANGE, COAST_C, EROS[6], d, 0.0f, (ResourceKey<Biome>)Biomes.RIVER);
        this.emitSurface(out, Climate.Parameter.span((Climate.Parameter)TEMPS[1], (Climate.Parameter)TEMPS[2]), FULL_RANGE, Climate.Parameter.span((Climate.Parameter)INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, (ResourceKey<Biome>)Biomes.SWAMP);
        this.emitSurface(out, Climate.Parameter.span((Climate.Parameter)TEMPS[3], (Climate.Parameter)TEMPS[4]), FULL_RANGE, Climate.Parameter.span((Climate.Parameter)INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, (ResourceKey<Biome>)Biomes.MANGROVE_SWAMP);
        this.emitSurface(out, FROZEN_RANGE, FULL_RANGE, Climate.Parameter.span((Climate.Parameter)INLAND_C, (Climate.Parameter)FAR_INLAND_C), EROS[6], d, 0.0f, (ResourceKey<Biome>)Biomes.FROZEN_RIVER);
        this.grid((ti, hi) -> {
            Climate.Parameter T = TEMPS[ti];
            Climate.Parameter H = HUMS[hi];
            ResourceKey<Biome> midOrBad = this.pickMiddleOrBadlandsIfHot(ti, hi, d);
            this.emitSurface(out, T, H, Climate.Parameter.span((Climate.Parameter)MID_INLAND_C, (Climate.Parameter)FAR_INLAND_C), Climate.Parameter.span((Climate.Parameter)EROS[0], (Climate.Parameter)EROS[1]), d, 0.0f, midOrBad);
        });
    }

    private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out) {
        this.emitUnderground(out, FULL_RANGE, FULL_RANGE, Climate.Parameter.span((float)0.8f, (float)1.0f), FULL_RANGE, FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.DRIPSTONE_CAVES);
        this.emitUnderground(out, FULL_RANGE, Climate.Parameter.span((float)0.7f, (float)1.0f), FULL_RANGE, FULL_RANGE, FULL_RANGE, 0.0f, JSBiomes.MAGMA_CAVES.getBiomeKey());
    }

    private ResourceKey<Biome> pickMiddle(int t, int h, Climate.Parameter d) {
        ResourceKey<Biome> base = d.max() < 0L ? MIDDLE[t][h] : Optional.ofNullable(MIDDLE_VAR[t][h]).orElse(MIDDLE[t][h]);
        return this.withRarity(base, t, h, d);
    }

    private ResourceKey<Biome> pickMiddleOrBadlandsIfHot(int t, int h, Climate.Parameter d) {
        ResourceKey<Biome> base = t == 4 ? this.pickBadlands(h, d) : this.pickMiddle(t, h, d);
        return this.withRarity(base, t, h, d);
    }

    private ResourceKey<Biome> pickMiddleOrBadlandsIfHotOrSlopeIfCold(int t, int h, Climate.Parameter d) {
        ResourceKey<Biome> base = t == 0 ? this.pickSlope(t, h, d) : this.pickMiddleOrBadlandsIfHot(t, h, d);
        return this.withRarity(base, t, h, d);
    }

    private ResourceKey<Biome> maybeWindsweptSavanna(int t, int h, Climate.Parameter d, ResourceKey<Biome> fallback) {
        ResourceKey base = t > 1 && h < 4 && d.max() >= 0L ? Biomes.WINDSWEPT_SAVANNA : fallback;
        return this.withRarity(base, t, h, d);
    }

    private ResourceKey<Biome> pickShatteredCoast(int t, int h, Climate.Parameter d) {
        ResourceKey<Biome> base = d.max() >= 0L ? this.pickMiddle(t, h, d) : this.pickBeach(t, h);
        base = this.maybeWindsweptSavanna(t, h, d, base);
        return this.withRarity(base, t, h, d);
    }

    private ResourceKey<Biome> pickBeach(int t, int h) {
        if (t == 0) {
            return Biomes.SNOWY_BEACH;
        }
        return t == 4 ? Biomes.DESERT : Biomes.BEACH;
    }

    private ResourceKey<Biome> pickBadlands(int h, Climate.Parameter d) {
        if (h < 2) {
            return d.max() < 0L ? Biomes.BADLANDS : Biomes.ERODED_BADLANDS;
        }
        return h < 3 ? Biomes.BADLANDS : Biomes.WOODED_BADLANDS;
    }

    private ResourceKey<Biome> pickPlateau(int t, int h, Climate.Parameter d) {
        ResourceKey<Biome> base = d.max() >= 0L && PLATEAU_VAR[t][h] != null ? PLATEAU_VAR[t][h] : PLATEAU[t][h];
        return this.withRarity(base, t, h, d);
    }

    private ResourceKey<Biome> pickPeak(int t, int h, Climate.Parameter d) {
        Object base = t <= 2 ? (d.max() < 0L ? Biomes.JAGGED_PEAKS : Biomes.FROZEN_PEAKS) : (t == 3 ? Biomes.STONY_PEAKS : this.pickBadlands(h, d));
        return this.withRarity((ResourceKey<Biome>)base, t, h, d);
    }

    private ResourceKey<Biome> pickSlope(int t, int h, Climate.Parameter d) {
        Object base = t >= 3 ? this.pickPlateau(t, h, d) : (h <= 1 ? Biomes.SNOWY_SLOPES : Biomes.GROVE);
        return this.withRarity((ResourceKey<Biome>)base, t, h, d);
    }

    private ResourceKey<Biome> pickShattered(int t, int h, Climate.Parameter d) {
        ResourceKey<Biome> base = Optional.ofNullable(SHATTERED[t][h]).orElse(this.pickMiddle(t, h, d));
        return this.withRarity(base, t, h, d);
    }

    private void emitSurface(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out, Climate.Parameter T, Climate.Parameter H, Climate.Parameter C, Climate.Parameter E, Climate.Parameter D, float W, ResourceKey<Biome> key) {
        ResourceKey<Biome> k = key;
        Climate.ParameterPoint p1 = Climate.parameters((Climate.Parameter)T, (Climate.Parameter)H, (Climate.Parameter)C, (Climate.Parameter)E, (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)D, (float)W);
        Climate.ParameterPoint p2 = Climate.parameters((Climate.Parameter)T, (Climate.Parameter)H, (Climate.Parameter)C, (Climate.Parameter)E, (Climate.Parameter)Climate.Parameter.point((float)1.0f), (Climate.Parameter)D, (float)W);
        out.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)p1, k));
        out.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)p2, k));
    }

    private void emitUnderground(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> out, Climate.Parameter T, Climate.Parameter H, Climate.Parameter C, Climate.Parameter E, Climate.Parameter D, float W, ResourceKey<Biome> key) {
        Climate.ParameterPoint p = Climate.parameters((Climate.Parameter)T, (Climate.Parameter)H, (Climate.Parameter)C, (Climate.Parameter)E, (Climate.Parameter)Climate.Parameter.span((float)0.2f, (float)0.9f), (Climate.Parameter)D, (float)W);
        out.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)p, key));
    }

    private void grid(Cell cell) {
        for (int ti = 0; ti < TEMPS.length; ++ti) {
            for (int hi = 0; hi < HUMS.length; ++hi) {
                cell.accept(ti, hi);
            }
        }
    }

    private ResourceKey<Biome> withRarity(ResourceKey<Biome> base, int t, int h, Climate.Parameter d) {
        WeightBag<ResourceKey<Biome>> bag = this.rarityPools.get(base);
        if (bag == null) {
            return base;
        }
        long hash = JSBiomeBuilder.mix(this.raritySalt, t, h, d.min(), d.max());
        return bag.pick(hash);
    }

    private static long mix(long salt, int t, int h, long dMin, long dMax) {
        long x = salt ^ 0x9E3779B97F4A7C15L;
        x ^= (long)t * -4658895280553007687L;
        x ^= (long)h * -7723592293110705685L;
        x ^= (dMin & 0xFFFFL) * 2685821657736338717L;
        return (x ^= (dMax & 0xFFFFL) * 1311768467294899695L) == 0L ? 1L : x;
    }

    private static final class WeightBag<T> {
        private final List<T> items = new ArrayList<T>();
        private final List<Integer> cum = new ArrayList<Integer>();
        private int total = 0;

        private WeightBag() {
        }

        WeightBag<T> add(T item, int w) {
            if (w <= 0) {
                return this;
            }
            this.total += w;
            this.items.add(item);
            this.cum.add(this.total);
            return this;
        }

        T pick(long seed) {
            if (this.items.isEmpty()) {
                throw new IllegalStateException("Empty weight bag");
            }
            if (this.items.size() == 1) {
                return this.items.get(0);
            }
            long r = WeightBag.nextPositive(seed) % (long)this.total;
            int idx = Collections.binarySearch(this.cum, (int)r + 1);
            if (idx < 0) {
                idx = -idx - 1;
            }
            return this.items.get(idx);
        }

        private static long nextPositive(long x) {
            x ^= x << 13;
            x ^= x >>> 7;
            x ^= x << 17;
            return x & Long.MAX_VALUE;
        }
    }

    private static interface Cell {
        public void accept(int var1, int var2);
    }
}

