/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.world.feature.obj;

import com.mojang.serialization.Codec;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BurntTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public BurntTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        if (level.getBlockState(pos.below()).isAir() || !level.getBlockState(pos.below()).isSolid()) {
            return false;
        }
        boolean canBeBurning = random.nextFloat() > 0.25f;
        BlockState log = ((Block)JSV2Blocks.BURNT_LOG.get()).defaultBlockState();
        BlockState burning_log = ((Block)JSV2Blocks.BURNING_LOG.get()).defaultBlockState();
        int height = 3 + random.nextInt(4);
        for (int y = 0; y < height; ++y) {
            BlockPos logPos = pos.above(y);
            if (!level.isEmptyBlock(logPos)) continue;
            if (canBeBurning && random.nextFloat() > 0.4f) {
                level.setBlock(logPos, burning_log, 2);
                continue;
            }
            level.setBlock(logPos, log, 2);
        }
        return true;
    }
}

