/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.world.feature.obj;

import com.mojang.serialization.Codec;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DeadTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public DeadTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        if (level.getBlockState(pos.below()).isAir() || !level.getBlockState(pos.below()).isSolid()) {
            return false;
        }
        BlockState log = ((Block)JSV2Blocks.DEAD_WOOD.get()).defaultBlockState();
        int height = 3 + random.nextInt(3);
        for (int y = 0; y < height; ++y) {
            BlockPos logPos = pos.above(y);
            if (!level.isEmptyBlock(logPos)) continue;
            level.setBlock(logPos, log, 2);
        }
        return true;
    }
}

