/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.world.feature.obj;

import com.mojang.serialization.Codec;
import java.util.Random;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import jp.jurassicsaga.server.v2.block.obj.GeyserBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GeiserFeature
extends Feature<NoneFeatureConfiguration> {
    private final Random secondaryRandom = new Random();

    public GeiserFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        double d;
        int dz;
        int dx;
        int radius;
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BlockPos surface = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, origin);
        while (level.isEmptyBlock(surface) && surface.getY() > level.getMinBuildHeight()) {
            surface = surface.below();
        }
        if (!level.getBlockState(surface).isSolid()) {
            return false;
        }
        int depth = 3 + random.nextInt(3);
        int topR = radius + 2;
        int clearHeight = 8;
        for (radius = 4 + random.nextInt(4); radius > 2; --radius) {
            boolean solid = true;
            block2: for (dx = -radius; dx <= radius; ++dx) {
                for (dz = -radius; dz <= radius; ++dz) {
                    BlockPos below;
                    d = Math.sqrt(dx * dx + dz * dz);
                    if (!(d <= (double)radius + 0.5) || !level.isEmptyBlock(below = surface.below(1).offset(dx, 0, dz)) && level.getBlockState(below).isSolid()) continue;
                    solid = false;
                    break block2;
                }
            }
            if (solid) break;
        }
        if (radius < 3) {
            return false;
        }
        for (int dx2 = -topR; dx2 <= topR; ++dx2) {
            for (int dz2 = -topR; dz2 <= topR; ++dz2) {
                BlockPos above;
                double d2 = Math.sqrt(dx2 * dx2 + dz2 * dz2);
                if (!(d2 <= (double)topR + 0.5)) continue;
                int height = (int)Mth.lerp((double)(d2 / (double)topR), (double)clearHeight, (double)2.0);
                BlockPos start = surface.offset(dx2, 1, dz2);
                for (int ay = 0; ay < height && level.getBlockState(above = start.above(ay)).getDestroySpeed((BlockGetter)level, above) != -1.0f; ++ay) {
                    level.setBlock(above, Blocks.AIR.defaultBlockState(), 2);
                }
            }
        }
        boolean hasGeyser = random.nextBoolean();
        for (int y = 0; y <= depth; ++y) {
            int layerR = Math.max(1, (int)Math.round((double)radius * (1.0 - (double)y / ((double)depth + 0.5))));
            for (int dx3 = -layerR - 2; dx3 <= layerR + 2; ++dx3) {
                for (int dz3 = -layerR - 2; dz3 <= layerR + 2; ++dz3) {
                    double d3 = Math.sqrt(dx3 * dx3 + dz3 * dz3);
                    BlockPos p = surface.below(y).offset(dx3, 0, dz3);
                    if (level.getBlockState(p).getDestroySpeed((BlockGetter)level, p) == -1.0f) continue;
                    if (d3 <= (double)layerR + 0.1) {
                        if (y == depth) {
                            if (random.nextFloat() < 0.3f) {
                                level.setBlock(p, ((Block)JSV2Blocks.VOLCANIC_MAGMA.get()).defaultBlockState(), 2);
                                continue;
                            }
                            if (random.nextFloat() > 0.5f && !hasGeyser) {
                                BlockState blockstate = ((Block)JSV2Blocks.GEYSER_BLOCK.get()).defaultBlockState();
                                int value = depth + radius + 4;
                                value = Math.min(16, value);
                                value = Math.max(8, value);
                                blockstate = (BlockState)blockstate.setValue((Property)GeyserBlock.HEIGHT, (Comparable)Integer.valueOf(Math.max(8, Math.min(16, value))));
                                level.setBlock(p, blockstate, 2);
                                level.scheduleTick(p, (Block)JSV2Blocks.GEYSER_BLOCK.get(), 1);
                                hasGeyser = true;
                                continue;
                            }
                            level.setBlock(p, Blocks.MUD.defaultBlockState(), 2);
                            continue;
                        }
                        level.setBlock(p, Blocks.WATER.defaultBlockState(), 2);
                        continue;
                    }
                    if (!(d3 <= (double)layerR + 2.1)) continue;
                    if (random.nextFloat() < 0.3f && y > depth / 3) {
                        level.setBlock(p, ((Block)JSV2Blocks.VOLCANIC_MAGMA.get()).defaultBlockState(), 2);
                        continue;
                    }
                    if (random.nextFloat() > 0.55f && y == 0) {
                        if (this.secondaryRandom.nextFloat() > 0.7f) {
                            level.setBlock(p, Blocks.DRIPSTONE_BLOCK.defaultBlockState(), 2);
                            if (!(random.nextFloat() > 0.9f)) continue;
                            level.setBlock(p.above(), Blocks.POINTED_DRIPSTONE.defaultBlockState(), 2);
                            continue;
                        }
                        level.setBlock(p, Blocks.PACKED_MUD.defaultBlockState(), 2);
                        continue;
                    }
                    level.setBlock(p, Blocks.MUD.defaultBlockState(), 2);
                }
            }
        }
        for (dx = -radius - 3; dx <= radius + 3; ++dx) {
            for (dz = -radius - 3; dz <= radius + 3; ++dz) {
                BlockPos rim;
                d = Math.sqrt(dx * dx + dz * dz);
                if (!(d > (double)radius) || !(d <= (double)radius + 3.0) || !level.getBlockState(rim = surface.offset(dx, 0, dz)).canBeReplaced() && !level.getBlockState(rim).isAir()) continue;
                level.setBlock(rim, Blocks.MUD.defaultBlockState(), 2);
            }
        }
        return true;
    }
}

