/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.world.feature.obj;

import com.mojang.serialization.Codec;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SmoothBoulderFeature
extends Feature<NoneFeatureConfiguration> {
    public SmoothBoulderFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel level = ctx.level();
        BlockPos pos = ctx.origin();
        RandomSource random = ctx.random();
        BlockPos.MutableBlockPos ground = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
        while (ground.getY() > level.getMinBuildHeight() && level.isEmptyBlock((BlockPos)ground)) {
            ground.move(0, -1, 0);
        }
        if (!level.getFluidState((BlockPos)ground).isEmpty() || !level.getFluidState(ground.above()).isEmpty()) {
            return false;
        }
        ground.move(0, -random.nextInt(2), 0);
        int radius = 3 + random.nextInt(2);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    if (!(dist <= (double)((float)radius + random.nextFloat() * 0.2f))) continue;
                    BlockPos target = ground.offset(x, y, z);
                    double fade = Math.max(0.0, 1.0 - (double)(-y) / ((double)radius * 1.5));
                    if (!((double)random.nextFloat() < fade)) continue;
                    if ((double)random.nextFloat() < 0.015 && this.isExposed(level, target)) {
                        level.setBlock(target, ((Block)JSV2Blocks.FUMAROLE.get()).defaultBlockState(), 2);
                        continue;
                    }
                    if ((double)random.nextFloat() > 0.2) {
                        level.setBlock(target, ((Block)JSV2Blocks.VOLCANIC_ROCK.get()).defaultBlockState(), 2);
                        continue;
                    }
                    level.setBlock(target, ((Block)JSV2Blocks.RHYOLITE.BLOCK.get()).defaultBlockState(), 2);
                }
            }
        }
        return true;
    }

    private boolean isExposed(WorldGenLevel level, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!level.isEmptyBlock(pos.relative(dir))) continue;
            return true;
        }
        return false;
    }
}

