/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.GenericHerdPool;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicSauropodAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.BrachiosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class BrachiosaurusAnimal
extends AbstractJSAnimal<BrachiosaurusEntity> {
    public BrachiosaurusAnimal() {
        super("brachiosaurus");
        this.setAnimator(new BasicSauropodAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<BrachiosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(3.0f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(1.5f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<BrachiosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(20.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(10.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<BrachiosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{1.25f, 0.325f});
        miscProperties.setGuidebookOffset(new Vec2(-2.0f, 0.0f), new Vec2(0.0f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setGuideBookDescription("A massive sauropod from the Late Jurassic, characterized by its long neck and upright posture. Unlike other sauropods, its forelimbs were longer than its hindlimbs, allowing it to reach high vegetation. It likely traveled in groups and required vast amounts of plant material daily.");
        miscProperties.setGuideBookSource("North America, Europe");
        miscProperties.setGuideBookScientificName("Brachiosaurus altithorax");
        miscProperties.setAdvancementTitle("Reach For The Treetops");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<BrachiosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHerdTargets(GenericHerdPool.BASE_HERBIVORE_POOL);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
        socialGroupProperties.enableNesting();
    }

    @Override
    protected void applyItemProperties(JSItemProperties<BrachiosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(14997942, 8681523);
        itemProperties.setSpawnEggColorsMale(14997942, 10657094);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<BrachiosaurusEntity> attributes, EntityBaseProperties<BrachiosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setSizeDimorphism(9.0);
        base.setSizeClass(AnimalSizeClass.GIANT);
        base.setMaxTurnRate((double)0.1f);
        base.setRenderScale(3.75);
        base.setLocator(new JSAnimalBaseLocator());
        base.setTurnSmoothRate((double)0.1f);
        attributes.setPersistent();
        attributes.setEntityFactory(BrachiosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(120.0);
        attributes.setDimensions(7.5, 8.5);
        attributes.setMovementSpeed((double)0.157f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)1.4f);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
    }
}

