/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animations.extant;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.animations.JSAnimator;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;
import travelers.server.animal.obj.TravelersMoveAnalysis;

public class OstrichAnimations
extends JSAnimator<OstrichEntity> {
    @Override
    public void animate(OstrichEntity base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (base.isDead()) {
            JSAnimations.DEATH.sendForEntity((SmartAnimalBase)base);
            return;
        }
        if (!base.isInWater()) {
            if (base.isMoving()) {
                if (base.isRunning()) {
                    JSAnimations.RUN.sendForEntity((SmartAnimalBase)base);
                } else {
                    JSAnimations.WALK.sendForEntity((SmartAnimalBase)base);
                }
            } else {
                JSAnimations.IDLE.sendForEntity((SmartAnimalBase)base);
            }
        } else if (base.onGround()) {
            if (base.isMoving()) {
                if (base.isRunning()) {
                    JSAnimations.RUN.sendForEntity((SmartAnimalBase)base);
                } else {
                    JSAnimations.WALK.sendForEntity((SmartAnimalBase)base);
                }
            } else {
                JSAnimations.IDLE.sendForEntity((SmartAnimalBase)base);
            }
        } else if (base.getDeltaMovement().horizontalDistanceSqr() > 0.0) {
            JSAnimations.SWIM.sendForEntity((SmartAnimalBase)base);
        } else {
            JSAnimations.IDLE_IN_WATER.sendForEntity((SmartAnimalBase)base);
        }
    }

    @Override
    public void animateServer(OstrichEntity base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (base.isDead()) {
            return;
        }
        if (base.curInjuredTicks > 0) {
            JSAnimations.INJURED.sendForEntity((SmartAnimalBase)base);
            return;
        }
        if (base.curAttackTicks > 0) {
            JSAnimations.ATTACK.sendForEntity((SmartAnimalBase)base);
            return;
        }
        if (animationManager.playTransition(base.isSleeping(), JSAnimations.SLEEP_IN.wrap(63), JSAnimations.SLEEP_LOOP.wrap(), JSAnimations.SLEEP_OUT.wrap(39))) {
            return;
        }
        if (animationManager.playTransition(base.isResting(), JSAnimations.REST_IN.wrap(36), JSAnimations.REST_LOOP.wrap(), JSAnimations.REST_OUT.wrap(19))) {
            return;
        }
    }
}

