/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extant;

import java.util.Random;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class GoatEntity
extends JSAnimalBase {
    public static final EntityDataAccessor<Integer> goat_variant = SynchedEntityData.defineId(GoatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public GoatEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setGoatVariant(GoatType.getRandom());
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 15));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(10, 8));
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getTarget() != null || this.getFleeTarget() != null) {
            return (SoundEvent)JSV1Sounds.GOAT_ALARM.get();
        }
        return (SoundEvent)JSV1Sounds.GOAT_LIVING.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSV1Sounds.GOAT_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.GOAT_HURT.get();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(goat_variant, (Object)GoatType.JURASSIC_PARK.ordinal());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setGoatVariant(GoatType.values()[pCompound.getInt("js.goat_variant")]);
    }

    public GoatType getGoatVariant() {
        return GoatType.values()[(Integer)this.entityData.get(goat_variant)];
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("js.goat_variant", this.getGoatVariant().ordinal());
    }

    @Override
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Biome biomeResult;
        Holder biome = level.getBiomeManager().getBiome(this.blockPosition());
        if (spawnType == MobSpawnType.SPAWN_EGG || spawnType == MobSpawnType.MOB_SUMMONED) {
            this.setGoatVariant(GoatType.getRandom());
        }
        if ((biomeResult = (Biome)biome.value()).coldEnoughToSnow(this.blockPosition())) {
            this.setGoatVariant(GoatType.JPOG);
        } else if (!biomeResult.hasPrecipitation()) {
            this.setGoatVariant(GoatType.JURASSIC_PARK);
        } else if (biomeResult.getBaseTemperature() >= 0.8f) {
            this.setGoatVariant(GoatType.JWE);
        } else {
            this.setGoatVariant(GoatType.JURASSIC_WORLD);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    private void setGoatVariant(GoatType random) {
        this.entityData.set(goat_variant, (Object)random.ordinal());
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Entity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean flag = MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || GoatEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, pos);
        boolean state = level.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON);
        return state && flag;
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) > 8;
    }

    public static enum GoatType {
        JURASSIC_PARK("jp"),
        JPOG("jpog"),
        JWE("jwe"),
        JURASSIC_WORLD("jw");

        private final String typeName;
        private static final Random rng;

        private GoatType(String typeName) {
            this.typeName = typeName;
        }

        public static GoatType getRandom() {
            return GoatType.values()[rng.nextInt(GoatType.values().length)];
        }

        public String getTypeName() {
            return this.typeName;
        }

        static {
            rng = new Random();
        }
    }
}

