/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class MosquitoEntity
extends JSAvianBase {
    public MosquitoEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.moveController = this.flyingMoveControl;
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(6, 6));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, false));
    }

    public static boolean canSpawn(EntityType<? extends Entity> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.getBlockState(blockPos).is(Blocks.AIR) && serverLevelAccessor.getBrightness(LightLayer.SKY, blockPos) > 9;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isFlying()) {
            return (SoundEvent)JSV1Sounds.MOSQUITO_FLIGHT_LOOP.get();
        }
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.MOSQUITO_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSV1Sounds.MOSQUITO_HURT.get();
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean shouldDieInstantly() {
        return true;
    }

    @Override
    public boolean disableFlyTransitions() {
        return true;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return this.getFlyingPathNavigation();
    }

    public int getMaxSpawnClusterSize() {
        return 40;
    }
}

