/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.LeapOutOfWaterTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.TylosaurCombatFollow;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class TylosaurusEntity
extends JSAquaticBase
implements IJSLeapingEntity {
    public static final EntityDataAccessor<Boolean> leaping = SynchedEntityData.defineId(TylosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean wasInWater = true;

    public TylosaurusEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSV1Sounds.TYLOSAURUS_LIVING.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSV1Sounds.TYLOSAURUS_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.TYLOSAURUS_HURT.get();
    }

    @Override
    public void tick() {
        this.wasInWater = this.isInWater();
        super.tick();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.isLeaping() && this.isInWater() != this.wasInWater && this.level().isClientSide) {
            int i = 0;
            while ((float)i < this.getBbWidth() + this.getBbHeight()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + (this.random.nextDouble() * 2.0 - 0.5) * (double)this.getBbWidth(), this.getY() + (this.random.nextDouble() * 2.0 - 0.5) * (double)this.getBbWidth(), this.getZ() + (this.random.nextDouble() * 2.0 - 0.5) * (double)this.getBbWidth(), (double)0.1f, this.random.nextDouble() * (double)this.getBbHeight(), (double)0.1f);
                ++i;
            }
        }
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(32, 16).setYVariation(8));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new TylosaurCombatFollow(this));
        controller.registerTask((TravelerTaskBase)new LeapOutOfWaterTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    protected int attackAnimLength() {
        return 15;
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(leaping, (Object)false);
    }

    @Override
    protected double getUpLift() {
        return 0.035;
    }

    @Override
    public void attack(LivingEntity target) {
        super.attack(target);
        this.doSweepAttack((Entity)this, 5.0f, 6.0f, this.getBbWidth());
    }

    public void doSweepAttack(Entity attacker, float width, float height, float depth) {
        Vec3 look = attacker.getLookAngle().normalize();
        Vec3 center = attacker.position().add(look.scale((double)(depth / 2.0f))).add(0.0, (double)(attacker.getBbHeight() / 2.0f), 0.0);
        AABB hitbox = new AABB(center.x - (double)(width / 2.0f), center.y - (double)(height / 2.0f), center.z - (double)(width / 2.0f), center.x + (double)(width / 2.0f), center.y + (double)(height / 2.0f), center.z + (double)(width / 2.0f));
        List targets = attacker.level().getEntitiesOfClass(LivingEntity.class, hitbox, e -> e != attacker);
        for (LivingEntity target : targets) {
            this.doHurtTarget((Entity)target);
        }
    }

    @Override
    public boolean isLeaping() {
        return (Boolean)this.entityData.get(leaping);
    }

    @Override
    public void setLeaping(boolean isLeaping) {
        this.entityData.set(leaping, (Object)isLeaping);
    }

    @Override
    public void onLeap() {
    }
}

