/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRangedAttackTask;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DiloSpitTask
extends JSRangedAttackTask {
    private final DilophosaurusEntity dilophosaurusEntity;
    private int runTicks;

    public DiloSpitTask(DilophosaurusEntity baseAnimal, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        super(baseAnimal, speedModifier, attackIntervalMin, attackIntervalMax, attackRadius);
        this.dilophosaurusEntity = baseAnimal;
    }

    @Override
    public boolean canContinueRunning() {
        if (this.runTicks == 0) {
            this.checkCooldown = 8;
            return false;
        }
        if (this.animal.getTarget() != null) {
            Player player;
            LivingEntity livingEntity = this.animal.getTarget();
            if (livingEntity instanceof Player && (player = (Player)livingEntity).isCreative()) {
                this.animal.setTarget(null);
                return false;
            }
        } else {
            --this.runTicks;
        }
        return super.canContinueRunning() && this.dilophosaurusEntity.getTarget() != null && this.dilophosaurusEntity.distanceTo((Entity)this.dilophosaurusEntity.getTarget()) > 6.0f;
    }

    @Override
    protected boolean runOnce() {
        return true;
    }

    @Override
    public boolean shouldRun() {
        Player player;
        LivingEntity livingEntity;
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
            return false;
        }
        if (this.animal.getTarget() != null && (livingEntity = this.animal.getTarget()) instanceof Player && (player = (Player)livingEntity).isCreative()) {
            this.animal.setTarget(null);
            return false;
        }
        if (this.animal.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            return false;
        }
        return super.shouldRun() && this.dilophosaurusEntity.getTarget() != null && this.dilophosaurusEntity.distanceTo((Entity)this.dilophosaurusEntity.getTarget()) > 6.0f;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.runTicks = 10;
        this.dilophosaurusEntity.frillDown = false;
        this.dilophosaurusEntity.frillUp = true;
    }

    @Override
    public void tick() {
        super.tick();
        this.dilophosaurusEntity.frillDown = false;
        this.dilophosaurusEntity.frillUp = true;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.dilophosaurusEntity.frillUp = false;
        this.dilophosaurusEntity.frillDown = true;
    }
}

