/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFlopTask
extends JSTaskBase {
    public JSFlopTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public TaskPriority getPriority() {
        if (!this.animal.isInWater()) {
            return TaskPriority.HIGH;
        }
        return TaskPriority.NONE;
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        return this.animal.onGround() && !this.animal.level().getFluidState(this.animal.blockPosition()).is(FluidTags.WATER);
    }

    public boolean canContinueRunning() {
        return !this.animal.isDead();
    }

    public void onStart() {
        BlockPos blockpos = null;
        Iterable posList = BlockPos.betweenClosed((int)Mth.floor((double)(this.animal.getX() - 2.0)), (int)Mth.floor((double)(this.animal.getY() - 2.0)), (int)Mth.floor((double)(this.animal.getZ() - 2.0)), (int)Mth.floor((double)(this.animal.getX() + 2.0)), (int)this.animal.getBlockY(), (int)Mth.floor((double)(this.animal.getZ() + 2.0)));
        for (BlockPos nextPos : posList) {
            if (!this.animal.level().getFluidState(nextPos).is(FluidTags.WATER)) continue;
            blockpos = nextPos;
            break;
        }
        if (blockpos != null) {
            this.animal.getMoveControl().setWantedPosition((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), 1.0);
        }
    }

    public void tick() {
    }

    public void onStop() {
    }
}

