/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StegosaurTailSwipe
extends JSHerdCombatFollowTask {
    private int tailSwipeTime;
    private boolean didSwipe;

    public StegosaurTailSwipe(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    @Override
    public void tick() {
        if (this.tailSwipeTime > 0) {
            if (this.tailSwipeTime < 20 && !this.didSwipe) {
                this.didSwipe = true;
                this.doSweepAttack((Entity)this.animal, 8.0f, 6.0f, this.animal.getBbWidth());
            }
            --this.tailSwipeTime;
            this.animal.stopInPlace();
        } else {
            super.tick();
        }
    }

    public boolean canInterrupt() {
        return this.tailSwipeTime == 0;
    }

    @Override
    protected void attack(LivingEntity target) {
        this.tailSwipeTime = 40;
        this.animal.curAttackTicks = 4;
        this.didSwipe = false;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.didSwipe = false;
        this.tailSwipeTime = 0;
    }

    public void doSweepAttack(Entity attacker, float width, float height, float depth) {
        Vec3 look = attacker.getLookAngle().normalize();
        Vec3 center = attacker.position().add(look.scale((double)(depth / 2.0f))).add(0.0, (double)(attacker.getBbHeight() / 2.0f), 0.0);
        AABB hitbox = new AABB(center.x - (double)(width / 2.0f), center.y - (double)(height / 2.0f), center.z - (double)(width / 2.0f), center.x + (double)(width / 2.0f), center.y + (double)(height / 2.0f), center.z + (double)(width / 2.0f));
        List targets = attacker.level().getEntitiesOfClass(LivingEntity.class, hitbox, e -> e.getType() != attacker.getType());
        for (LivingEntity target : targets) {
            this.animal.doHurtTarget((Entity)target);
            Vec3 attackerAngle = attacker.getLookAngle().normalize();
            double strength = 1.0;
            target.push(attackerAngle.x * strength, 0.3, attackerAngle.z * strength);
        }
    }
}

