/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import java.util.HashSet;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSPlantData;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.GeneExtractorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.obj.TravelersItemInterface;

public class GeneExtractorMachineEntity
extends GenericMachineEntity {
    public static final boolean removeGeneWhenExtract = true;
    public static final HashSet<Item> ACCEPTED_ITEMS = new HashSet();
    public static int maxExtractions = 3;
    private final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> GeneExtractorMachineEntity.this.progress;
                case 1 -> GeneExtractorMachineEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    GeneExtractorMachineEntity.this.progress = value;
                    break;
                }
                case 1: {
                    GeneExtractorMachineEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 5000;
    private int remainingExtractions = 3;
    private boolean isDisplayingItems = false;

    public GeneExtractorMachineEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(19, (Block)JSV1Blocks.GENE_EXTRACTOR.get(), (BlockEntityType)JSV1BlockEntities.GENE_EXTRACTOR.get(), p_155229_, p_155230_);
        if (ACCEPTED_ITEMS.isEmpty()) {
            GeneExtractorMachineEntity.init();
        }
    }

    private static void init() {
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            if (!animal.getAnimalAttributes().getItemProperties().isHasCoin() && !animal.getAnimalAttributes().getMiscProperties().isExtinct()) continue;
            TravelersItemInterface items = animal.getItems();
            ACCEPTED_ITEMS.add((Item)items.getCoin().get());
        }
        for (JSPlantData value : JSGenetics.PLANT_GENETIC_INFORMATION.values()) {
            ACCEPTED_ITEMS.add((Item)value.coin.get());
        }
    }

    private void localTick(Level lvl, GeneExtractorMachineEntity be) {
        if (lvl.isClientSide || ((ItemStack)this.items.getFirst()).isEmpty()) {
            return;
        }
        if (be.canOutput(be) && !this.isDisplayingItems && ACCEPTED_ITEMS.contains(((ItemStack)this.items.getFirst()).getItem())) {
            int speed = lvl.getGameRules().getInt(JSCommon.MACHINE_SPEED);
            be.progress += speed;
            if (be.progress >= be.maxProgress && !((ItemStack)this.items.getFirst()).isEmpty()) {
                ItemStack input = (ItemStack)this.items.getFirst();
                this.remainingExtractions = input.has((DataComponentType)JSDataComponents.GENE_EXTRACTOR_TRIES.get()) ? (Integer)input.getOrDefault((DataComponentType)JSDataComponents.GENE_EXTRACTOR_TRIES.get(), (Object)0) : maxExtractions;
                if (this.remainingExtractions > 0) {
                    JSGeneData geneticData = JSGeneUtil.readFromStack(input);
                    for (int i = 0; i < geneticData.geneDataHolder.getGENE_SET().size(); ++i) {
                        JSGene gene = geneticData.geneDataHolder.getGENE_SET().get(i);
                        this.items.set(i + 1, (Object)((Item)JSGenetics.GENE_ITEMS.get(gene).get()).getDefaultInstance());
                    }
                    this.isDisplayingItems = true;
                }
            }
        }
        be.setChanged();
    }

    private boolean canOutput(GeneExtractorMachineEntity be) {
        ItemStack input = (ItemStack)be.items.getFirst();
        if (!((ItemStack)be.items.getFirst()).isEmpty()) {
            JSGeneData data = JSGeneUtil.readFromStack(input);
            return data.getTotalCompletion() == 100 & !data.geneDataHolder.getGENE_SET().isEmpty();
        }
        return false;
    }

    public void onTookFromInputSlot(ItemStack stack) {
        ItemStack geneStack;
        if (!stack.isEmpty() && this.remainingExtractions != 0 && this.remainingExtractions != maxExtractions) {
            stack.set((DataComponentType)JSDataComponents.GENE_EXTRACTOR_TRIES.get(), (Object)this.remainingExtractions);
        }
        for (int i = 1; i < this.items.size() && (geneStack = (ItemStack)this.items.get(i)) != ItemStack.EMPTY; ++i) {
            geneStack.shrink(1);
            this.items.set(i, (Object)geneStack);
        }
        this.progress = 0;
        this.isDisplayingItems = false;
    }

    public void onTookFromOutputSlot(ItemStack stack) {
        ItemStack geneStack;
        this.progress = 0;
        this.isDisplayingItems = false;
        --this.remainingExtractions;
        ItemStack inputStack = (ItemStack)this.items.getFirst();
        Item item = stack.getItem();
        if (item instanceof GeneItem) {
            GeneItem item2 = (GeneItem)item;
            JSGene gene = item2.getGene();
            if (!inputStack.isEmpty()) {
                JSGeneData geneticData = JSGeneUtil.readFromStack(inputStack);
                geneticData.removeGene(gene);
                JSGeneUtil.wipeStack(inputStack);
                JSGeneUtil.writeToStack(inputStack, geneticData);
            }
        }
        if (!inputStack.isEmpty()) {
            if (this.remainingExtractions != 0) {
                inputStack.set((DataComponentType)JSDataComponents.GENE_EXTRACTOR_TRIES.get(), (Object)this.remainingExtractions);
            } else {
                inputStack.shrink(1);
            }
        }
        this.items.set(0, (Object)inputStack);
        for (int i = 1; i < this.items.size() && (geneStack = (ItemStack)this.items.get(i)) != ItemStack.EMPTY; ++i) {
            geneStack.shrink(1);
            this.items.set(i, (Object)geneStack);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, @NotNull Inventory p_39955_, @NotNull Player p_39956_) {
        return new GeneExtractorMenu(p_39954_, p_39955_, this, this.data);
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof GeneExtractorMachineEntity) {
            GeneExtractorMachineEntity ge = (GeneExtractorMachineEntity)be;
            ge.localTick(level, ge);
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }
}

