/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import java.util.Objects;
import java.util.Random;
import jp.jurassicsaga.server.util.JSHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class GenericMachineEntity
extends BlockEntity
implements MenuProvider {
    public final int SLOT_COUNT;
    protected NonNullList<ItemStack> items;
    private final Block block;
    private boolean blockUpdate;
    private int animTickDelay = 20;
    protected final Random random = new Random();

    public GenericMachineEntity(int slots, Block block, BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.SLOT_COUNT = slots;
        this.block = block;
        this.items = NonNullList.withSize((int)this.SLOT_COUNT, (Object)ItemStack.EMPTY);
    }

    protected void playSound(BlockState state, SoundEvent sound) {
        double x = (double)this.worldPosition.getX() + 0.5;
        double y = (double)this.worldPosition.getY() + 0.5;
        double z = (double)this.worldPosition.getZ() + 0.5;
        float volume = 0.5f;
        assert (this.level != null);
        float pitch = 1.5f;
        this.level.playSound(null, x, y, z, sound, SoundSource.BLOCKS, volume, pitch);
    }

    public abstract ContainerData getContainerData();

    protected void animate(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.SLOT_COUNT, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    public void drops() {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, this.items);
        }
    }

    @NotNull
    public Component getDisplayName() {
        return this.block.getName();
    }

    public abstract void workTick(Level var1, GenericMachineEntity var2, BlockState var3, BlockPos var4);

    public final void tick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be.level == null) {
            return;
        }
        this.workTick(level, be, state, pos);
        if (this.animTickDelay > 0) {
            --this.animTickDelay;
        } else {
            this.animate(level, be, state, pos);
        }
        if (level != null && this.blockUpdate) {
            level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.getLevel() != null && !this.isSilent()) {
            this.getLevel().playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    protected boolean isSilent() {
        return false;
    }

    public void playSound(SoundEvent sound) {
        if (sound != null) {
            this.playSound(sound, this.getSoundVolume(), this.getPitch());
        }
    }

    protected float getPitch() {
        return (Objects.requireNonNull(this.level).getRandom().nextFloat() - this.level.getRandom().nextFloat()) * 0.2f + 1.0f;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected void spawnParticle(ParticleOptions options, int count, float xf, float yf, float zf, float speed) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Vec3 center = this.getBlockPos().getCenter();
            server.sendParticles(options, center.x(), center.y(), center.z(), count, (double)xf, (double)yf, (double)zf, (double)speed);
        }
    }

    public boolean canAddItem(ItemStack stack) {
        int remaining = stack.getCount();
        for (ItemStack itemstack : this.items) {
            int space;
            if (itemstack.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack) || (remaining -= (space = itemstack.getMaxStackSize() - itemstack.getCount())) > 0) continue;
            return true;
        }
        return false;
    }

    public void openMenu(@NotNull Player player) {
        JSHelper.jsPlatform.openMenu(player, this.getBlockPos(), this);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isBlockUpdate() {
        return this.blockUpdate;
    }

    public void setBlockUpdate(boolean blockUpdate) {
        this.blockUpdate = blockUpdate;
    }
}

