/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSMetabolismModule;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.physics.HaybaleEntity;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.feeder.HerbivoreFeederMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class HerbivoreFeederEntity
extends GenericMachineEntity {
    private final ContainerData data;
    private int sliderPos = 50;
    private int openTicks = 0;
    private boolean hasToDispense;
    private int openTime = 0;
    private int closeTicks = 0;
    private int checkForFeedCooldown = 200;
    private boolean hasResult = false;
    private boolean dispenseHigher = false;
    private final ArrayList<Entity> dispensed = new ArrayList();

    public HerbivoreFeederEntity(BlockPos pos, BlockState blockState) {
        super(19, (Block)JSV1Blocks.HERBIVORE_FEEDER.get(), (BlockEntityType)JSV1BlockEntities.HERBIVORE_FEEDER.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return HerbivoreFeederEntity.this.sliderPos;
            }

            public void set(int index, int value) {
                HerbivoreFeederEntity.this.sliderPos = value;
            }

            public int getCount() {
                return 1;
            }
        };
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("sliderPos", this.sliderPos);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setSliderPos(tag.getInt("sliderPos"));
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("sliderPos", this.sliderPos);
        tag.putInt("openTicks", this.openTicks);
        tag.putInt("openTime", this.openTime);
        tag.putBoolean("hasToDispense", this.hasToDispense);
        tag.putInt("closeTicks", this.closeTicks);
        return tag;
    }

    @Override
    protected void animate(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof HerbivoreFeederEntity) {
            HerbivoreFeederEntity feeder = (HerbivoreFeederEntity)be;
            if (this.openTicks > 0) {
                if (this.openTicks == 40) {
                    feeder.playSound(state, (SoundEvent)JSSounds.HATCH_DOOR.get());
                }
                --this.openTicks;
                JSAnimations.OPEN.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
                return;
            }
            if (this.openTime > 0) {
                --this.openTime;
                JSAnimations.OPENED.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
                return;
            }
            if (this.closeTicks > 0) {
                if (this.closeTicks == 39) {
                    feeder.playSound(state, (SoundEvent)JSSounds.HATCH_DOOR.get());
                }
                --this.closeTicks;
                JSAnimations.CLOSE.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
            } else {
                JSAnimations.CLOSED.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
            }
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    public void setSliderPos(int sliderPos) {
        this.sliderPos = sliderPos;
        this.data.set(0, sliderPos);
        this.setChanged();
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.empty();
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof HerbivoreFeederEntity) {
            HerbivoreFeederEntity herbivoreFeederEntity = (HerbivoreFeederEntity)be;
            if (this.openTicks == 0 && this.openTime == 10 && this.hasToDispense) {
                for (int i = 0; i < 6 && this.tryDispenseOne(); ++i) {
                }
                if (level.isClientSide) {
                    if (this.hasResult && !this.dispenseHigher) {
                        Vec3 center = pos.getCenter();
                        for (int i = 0; i < 50; ++i) {
                            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 8.0f), center.x() + this.random.nextDouble() * 2.0 - 1.0, center.y() + 1.0 + this.random.nextDouble() - 1.0, center.z() + this.random.nextDouble() * 2.0 - 1.0, 4.0, 16.0, 4.0);
                        }
                    }
                    if (!this.dispensed.isEmpty()) {
                        List entities = level.getEntitiesOfClass(JSAnimalBase.class, new AABB(-64.0, -16.0, -64.0, 64.0, 64.0, 64.0).move(pos), base -> base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.HERBIVORE) && !base.isDead() && !base.isSleeping());
                        for (JSAnimalBase a : entities) {
                            if (!a.getModules().getMetabolismModule().isHungry()) continue;
                            Optional<Entity> randomEntity = this.dispensed.stream().filter(e -> e instanceof LivingEntity).findAny();
                            if (!randomEntity.isPresent()) break;
                            a.setTarget((LivingEntity)randomEntity.get());
                        }
                        this.dispensed.clear();
                    }
                }
                this.hasResult = false;
                this.hasToDispense = false;
            }
            if (level.isClientSide) {
                return;
            }
            if (this.checkForFeedCooldown > 0) {
                --this.checkForFeedCooldown;
            } else {
                List entities;
                List balesNearby = level.getEntitiesOfClass(HaybaleEntity.class, new AABB(-6.0, -12.0, -6.0, 6.0, 12.0, 6.0).move(pos), Entity::isAlive);
                if (balesNearby.size() < 3 && !(entities = level.getEntitiesOfClass(JSAnimalBase.class, new AABB(-24.0, -16.0, -24.0, 24.0, 32.0, 24.0).move(pos), base -> base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.HERBIVORE) && !base.isDead() && !base.isSleeping())).isEmpty()) {
                    for (JSAnimalBase entity : entities) {
                        JSMetabolismModule metabolism = entity.getModules().getMetabolismModule();
                        float percentage = (float)metabolism.hungerPercentage();
                        if (!(percentage * 100.0f < (float)(herbivoreFeederEntity.getSliderPos() + 20))) continue;
                        this.dispense();
                        this.checkForFeedCooldown = 1000;
                        return;
                    }
                }
                this.checkForFeedCooldown = 200;
            }
        }
    }

    private boolean tryDispenseOne() {
        int slot = -1;
        ItemStack stack = null;
        for (int i = 0; i < 5; ++i) {
            ItemStack itemSlot = (ItemStack)this.getItems().get(i);
            if (!itemSlot.is(ItemTags.LEAVES) && !itemSlot.is(JSItemTags.HERBIVORE_EDIBLE) || itemSlot.getCount() <= 1) continue;
            slot = i;
            stack = itemSlot;
            break;
        }
        if (slot == -1) {
            return false;
        }
        this.hasResult = true;
        if (this.level.isClientSide) {
            return true;
        }
        if (this.level.getGameRules().getBoolean(JSCommon.FEEDER_DISPENSE_DRAIN)) {
            stack.shrink(2);
        }
        this.getItems().set(slot, (Object)stack);
        HaybaleEntity entity = (HaybaleEntity)((EntityType)JSEntities.HAYBALE.get()).create(this.level);
        if (entity == null) {
            return false;
        }
        entity.setDeltaMovement(new Vec3(this.random.nextBoolean() ? -0.2 : 0.2 + (double)((this.random.nextFloat() - 0.5f) / 3.0f), 0.6 + (double)(this.random.nextFloat() / 2.0f), this.random.nextBoolean() ? -0.2 : 0.2 + (double)((this.random.nextFloat() - 0.5f) / 3.0f)));
        entity.setPos(this.getBlockPos().getCenter().add(0.0, 0.5, 0.0));
        this.level.addFreshEntity((Entity)entity);
        return true;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new HerbivoreFeederMenu(containerId, playerInventory, this, null);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void dispense() {
        BlockPos posAbove = this.getBlockPos().above();
        BlockState state = this.level.getBlockState(posAbove);
        if (state.isCollisionShapeFullBlock((BlockGetter)this.level, posAbove)) {
            this.playSound(this.getBlockState(), SoundEvents.CHEST_LOCKED);
            this.hasResult = false;
            this.openTicks = 0;
            this.openTime = 0;
            this.closeTicks = 0;
            this.hasToDispense = false;
            return;
        }
        boolean bl = this.dispenseHigher = !state.isAir();
        if (this.openTicks > 0 || this.openTime > 0 || this.closeTicks > 0) {
            return;
        }
        this.openTicks = 40;
        this.openTime = 40;
        this.closeTicks = 40;
        this.hasToDispense = true;
        this.setChanged();
    }

    public int getSliderPos() {
        return this.sliderPos;
    }
}

