/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.misc;

import java.util.List;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extant.MosquitoEntity;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.menu.obj.machine.BugZapperMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BugZapperEntity
extends GenericMachineEntity {
    private final ContainerData data = new ContainerData(this){

        public int get(int index) {
            return 0;
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 1;
        }
    };
    private int ticks = 0;

    public BugZapperEntity(BlockPos pPos, BlockState pBlockState) {
        super(1, (Block)JSV1Blocks.BUG_ZAPPER.get(), (BlockEntityType)JSV1BlockEntities.BUG_ZAPPER.get(), pPos, pBlockState);
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (!level.isClientSide && be instanceof BugZapperEntity) {
            ++this.ticks;
            List entities = level.getEntitiesOfClass(MosquitoEntity.class, new AABB(pos).inflate(10.0), LivingEntity::isAlive);
            ItemStack mosquitoSlot = (ItemStack)be.getItems().getFirst();
            for (LivingEntity mosquito : entities) {
                mosquito.kill();
                if (mosquitoSlot.isEmpty()) {
                    be.getItems().set(0, (Object)((Item)JSV1Items.MOSQUITO.get()).getDefaultInstance());
                    continue;
                }
                if (mosquitoSlot.getCount() + 1 > mosquitoSlot.getMaxStackSize()) break;
                mosquitoSlot.grow(1);
                be.getItems().set(0, (Object)mosquitoSlot);
            }
            if ((float)this.ticks % JSUtils.toTickMinutes(4.0f) == 0.0f) {
                if (mosquitoSlot.isEmpty()) {
                    be.getItems().set(0, (Object)((Item)JSV1Items.MOSQUITO.get()).getDefaultInstance());
                } else if (mosquitoSlot.getCount() + 1 <= mosquitoSlot.getMaxStackSize()) {
                    mosquitoSlot.grow(1);
                    be.getItems().set(0, (Object)mosquitoSlot);
                }
                this.ticks = 0;
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new BugZapperMenu(containerId, playerInventory, this, this.data);
    }
}

