/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.obj.entity.feeder;

import com.mojang.serialization.MapCodec;
import jp.jurassicsaga.server.base.block.obj.entity.GenericMachine;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder.HerbivoreFeederEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HerbivoreFeeder
extends GenericMachine {
    private final MapCodec<HerbivoreFeeder> codec = HerbivoreFeeder.simpleCodec(HerbivoreFeeder::new);

    public HerbivoreFeeder(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof HerbivoreFeederEntity) {
            HerbivoreFeederEntity machine = (HerbivoreFeederEntity)entity;
            if (player.isShiftKeyDown()) {
                machine.dispense();
            } else if (!level.isClientSide) {
                machine.openMenu(player);
            }
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        throw new IllegalStateException("JS Container provider is missing!");
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)-8.0, (double)0.0, (double)-8.0, (double)24.0, (double)4.0, (double)24.0);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HerbivoreFeederEntity(pos, state);
    }
}

