/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.menu.obj;

import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.JSSlotItemHandler;
import jp.jurassicsaga.server.v1.menu.obj.MachineContainerWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;

public abstract class GenericMachineMenu
extends AbstractContainerMenu {
    private final Level level;
    private final ContainerData data;
    public GenericMachineEntity blockEntity;
    protected int invXOffset = 8;
    protected int invYOffset = 84;
    protected int hotBarY = 142;

    public GenericMachineMenu(MenuType<?> menuType, int pContainerId, Inventory inv, RegistryFriendlyByteBuf extraData) {
        this(menuType, pContainerId, inv, (GenericMachineEntity)inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public GenericMachineMenu(MenuType<?> menuType, int pContainerId, Inventory inv, GenericMachineEntity blockEntity, ContainerData data) {
        super(menuType, pContainerId);
        GenericMachineMenu.checkContainerSize((Container)inv, (int)13);
        this.initOffset();
        this.level = inv.player.level();
        this.data = data;
        this.blockEntity = blockEntity;
        this.addSlots(new MachineContainerWrapper(blockEntity));
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        if (data != null) {
            this.addDataSlots(data);
        }
    }

    protected void initOffset() {
    }

    protected abstract void addSlots(SimpleContainer var1);

    private void addPlayerInventory(Inventory playerInventory) {
        this.invYOffset += 10;
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, this.invXOffset + l * 18 + this.getInvExtraXOffset(), this.invYOffset + i * 18 + this.getInvExtraYOffset()));
            }
        }
    }

    public int getInvExtraXOffset() {
        return 0;
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, this.invXOffset + i * 18 + this.getHotbarExtraXOffset(), this.hotBarY + this.getHotbarExtraYOffset()));
        }
    }

    public int getHotbarExtraXOffset() {
        return 0;
    }

    public boolean stillValid(Player pPlayer) {
        return GenericMachineMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)this.blockEntity.getBlock());
    }

    public int getInvExtraYOffset() {
        return 0;
    }

    public int getHotbarExtraYOffset() {
        return 0;
    }

    public Vector2d getPlayerInventoryLabelOffset() {
        return new Vector2d(0.0, 0.0);
    }

    public Vector2d getLabelOffset() {
        return new Vector2d(0.0, 0.0);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        int slotcount = this.slots.size() - 36;
        if (slotcount <= 0) {
            return ItemStack.EMPTY;
        }
        int endIndex = 36 + slotcount;
        if (pIndex >= slotcount && pIndex <= this.slots.size()) {
            if (!this.moveItemStackTo(sourceStack, 0, slotcount, false) && (pIndex < endIndex - 9 ? !this.moveItemStackTo(sourceStack, endIndex - 9, endIndex, false) : !this.moveItemStackTo(sourceStack, slotcount, endIndex - 9, false))) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < slotcount) {
            if (!this.moveItemStackTo(sourceStack, slotcount, endIndex, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        if (sourceSlot instanceof JSSlotItemHandler) {
            JSSlotItemHandler slotItemHandler = (JSSlotItemHandler)sourceSlot;
            slotItemHandler.onTake(pPlayer, sourceStack, copyOfSourceStack);
        } else {
            sourceSlot.onTake(pPlayer, sourceStack);
        }
        return copyOfSourceStack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                Slot slot = (Slot)this.slots.get(i);
                ItemStack itemstack = slot.getItem();
                if (!slot.mayPlace(stack)) {
                    flag = false;
                } else if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + stack.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        stack.setCount(0);
                        itemstack.setCount(j);
                        slot.setChanged();
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        stack.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.setChanged();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(stack)) {
                    int l = slot1.getMaxStackSize(stack);
                    slot1.setByPlayer(stack.split(Math.min(stack.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ContainerData getData() {
        return this.data;
    }
}

