/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.tree.placer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.world.tree.JSV1TrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class AraucarioxylonTrunkGrower
extends TrunkPlacer {
    public static final MapCodec<AraucarioxylonTrunkGrower> CODEC = RecordCodecBuilder.mapCodec(instance -> AraucarioxylonTrunkGrower.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, AraucarioxylonTrunkGrower::new));

    public AraucarioxylonTrunkGrower(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)JSV1TrunkPlacerTypes.ARAUCARIOXYLON.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockSetter, @NotNull RandomSource random, int freeTreeHeight, BlockPos pos, @NotNull TreeConfiguration config) {
        BlockPos trunkPos;
        int i;
        AraucarioxylonTrunkGrower.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        int trunkHeight = 30 + random.nextInt(20);
        int branchLength = (trunkHeight - 2) / 8;
        int step = 15;
        for (i = 0; i < trunkHeight; ++i) {
            trunkPos = pos.above(i);
            this.placeLog(level, blockSetter, random, trunkPos, config);
            if (i > 2 && i < trunkHeight - 2) {
                if (--step <= 0) {
                    step = 10;
                    branchLength = Math.max(1, branchLength - 1);
                }
                if (step == 5 || step == 10) {
                    this.placeBranches(level, blockSetter, trunkPos, branchLength);
                }
            }
            if (i != trunkHeight - 1) continue;
            this.placeLeavesAround(level, blockSetter, random, trunkPos, config);
            blockSetter.accept(trunkPos.above(2), ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).defaultBlockState());
        }
        step = 15;
        branchLength = (trunkHeight - 2) / 8;
        for (i = 0; i < trunkHeight; ++i) {
            if (i <= 2 || i >= trunkHeight - 2) continue;
            if (--step <= 0) {
                step = 10;
                branchLength = Math.max(1, branchLength - 1);
            }
            if (step != 5 && step != 10) continue;
            trunkPos = pos.above(i);
            this.placeBranchLeaves(level, blockSetter, random, trunkPos, config, branchLength);
        }
        return ImmutableList.of();
    }

    private void placeBranches(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos base, int length) {
        BlockState log = ((Block)JSV1Blocks.ARAUCARIOXYLON.LOG.get()).defaultBlockState();
        for (int j = 0; j < length; ++j) {
            blockSetter.accept(base.below(j).north(j), log);
            blockSetter.accept(base.below(j).east(j), log);
            blockSetter.accept(base.below(j).south(j), log);
            blockSetter.accept(base.below(j).west(j), log);
        }
    }

    private void placeBranchLeaves(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos base, TreeConfiguration config, int length) {
        for (int j = 0; j < length; ++j) {
            this.placeLeavesAround(level, blockSetter, random, base.below(j).north(j), config);
            this.placeLeavesAround(level, blockSetter, random, base.below(j).east(j), config);
            this.placeLeavesAround(level, blockSetter, random, base.below(j).south(j), config);
            this.placeLeavesAround(level, blockSetter, random, base.below(j).west(j), config);
        }
    }

    private void placeLeavesAround(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        for (BlockPos offset : new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()}) {
            if (!this.isValid(level, offset)) continue;
            blockSetter.accept(offset, ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).defaultBlockState());
        }
    }

    private boolean isValid(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::isAir);
    }
}

