/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.tree.placer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import jp.jurassicsaga.server.v1.world.tree.JSV1TrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class SpinifructusTrunkGrower
extends TrunkPlacer {
    public static final MapCodec<SpinifructusTrunkGrower> CODEC = RecordCodecBuilder.mapCodec(instance -> SpinifructusTrunkGrower.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SpinifructusTrunkGrower::new));

    public SpinifructusTrunkGrower(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)JSV1TrunkPlacerTypes.SPINIFRUCTUS.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockSetter, @NotNull RandomSource random, int freeTreeHeight, BlockPos pos, @NotNull TreeConfiguration config) {
        SpinifructusTrunkGrower.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        int height = this.baseHeight + random.nextInt(this.heightRandA + 1) + random.nextInt(this.heightRandB + 1);
        if (height < 6) {
            height = 6;
        }
        if (height > 12) {
            height = 12;
        }
        BlockPos topPos = pos;
        for (int i = 0; i < height; ++i) {
            topPos = pos.above(i);
            blockSetter.accept(topPos, config.trunkProvider.getState(random, pos));
        }
        this.placePalmFronds(level, blockSetter, random, topPos, config);
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(topPos, 0, false));
    }

    private void placePalmFronds(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        BlockState leaves = config.foliageProvider.getState(random, pos);
        int horizLength = 3;
        int diagLength = 1;
        int upLength = 1;
        int downLength = 2;
        this.buildCrown(level, blockSetter, pos, leaves, horizLength, diagLength, upLength, downLength, false);
        this.buildCrown(level, blockSetter, pos, leaves, horizLength, diagLength, downLength, upLength, true);
    }

    private void buildCrown(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState leaves, int horizLength, int diagLength, int upLength, int downLength, boolean inverted) {
        int i;
        for (i = 1; i <= upLength; ++i) {
            this.tryPlaceLeaf(level, blockSetter, pos.above(i), leaves);
        }
        for (i = 1; i <= downLength; ++i) {
            this.tryPlaceLeaf(level, blockSetter, pos.below(i), leaves);
        }
        this.extendFrond(level, blockSetter, pos, leaves, Direction.NORTH, horizLength, inverted);
        this.extendFrond(level, blockSetter, pos, leaves, Direction.SOUTH, horizLength, inverted);
        this.extendFrond(level, blockSetter, pos, leaves, Direction.EAST, horizLength, inverted);
        this.extendFrond(level, blockSetter, pos, leaves, Direction.WEST, horizLength, inverted);
        this.extendDiagonalFrond(level, blockSetter, pos, leaves, Direction.NORTH, Direction.EAST, diagLength, inverted);
        this.extendDiagonalFrond(level, blockSetter, pos, leaves, Direction.NORTH, Direction.WEST, diagLength, inverted);
        this.extendDiagonalFrond(level, blockSetter, pos, leaves, Direction.SOUTH, Direction.EAST, diagLength, inverted);
        this.extendDiagonalFrond(level, blockSetter, pos, leaves, Direction.SOUTH, Direction.WEST, diagLength, inverted);
    }

    private void extendFrond(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState state, Direction dir, int length, boolean inverted) {
        for (int i = 1; i <= length; ++i) {
            int offset = i >= 3 ? 1 : 0;
            BlockPos cur = inverted ? pos.relative(dir, i).above(offset) : pos.relative(dir, i).below(offset);
            this.tryPlaceLeaf(level, blockSetter, cur, state);
            if (i != length) continue;
            this.tryPlaceLeaf(level, blockSetter, inverted ? cur.above() : cur.below(), state);
        }
    }

    private void extendDiagonalFrond(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState state, Direction dir1, Direction dir2, int length, boolean inverted) {
        for (int i = 1; i <= length; ++i) {
            int offset = i >= 3 ? 1 : 0;
            BlockPos cur = pos.relative(dir1, i).relative(dir2, i);
            cur = inverted ? cur.above(offset) : cur.below(offset);
            this.tryPlaceLeaf(level, blockSetter, cur, state);
            if (i != length) continue;
            this.tryPlaceLeaf(level, blockSetter, inverted ? cur.above() : cur.below(), state);
        }
    }

    private void tryPlaceLeaf(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState state) {
        if (this.isValid(level, pos)) {
            blockSetter.accept(pos, state);
        }
    }

    public boolean isValid(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::isAir);
    }
}

