/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.VelociraptorAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ApatosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.EuoplocephalusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MaiasauraEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.StyracosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class AchillobatorAnimal
extends AbstractJSAnimal<AchillobatorEntity> {
    public AchillobatorAnimal() {
        super("achillobator");
        this.setAnimator(new VelociraptorAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<AchillobatorEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.87f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.CHAOS_EFFECT_COSMETIC, JSGenetics.RAINFOREST_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<AchillobatorEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(2.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.setStalkingSpeedMultiplier(0.7f);
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<AchillobatorEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.disableBabyGuidebook();
        miscProperties.setGuidebookScaling(new float[]{1.2f, 1.7f});
        miscProperties.setGuidebookOffset(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f));
        miscProperties.setExtinct();
        miscProperties.setVersion(2.0f);
        miscProperties.setGuideBookDescription("Achillobator meaning \"Achilles hero\" is a genus of large dromaeosaurid theropod dinosaur that lived during the Late Cretaceous period.");
        miscProperties.setGuideBookSource("China, Mongolia");
        miscProperties.setGuideBookScientificName("Achillobator giganticus");
        miscProperties.setAdvancementTitle("Population: 37");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<AchillobatorEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(AbstractVillager.class, Player.class, Monster.class, Animal.class, DryosaurusEntity.class, GoatEntity.class, OstrichEntity.class, ParasaurolophusEntity.class, HadrosaurusEntity.class, ApatosaurusEntity.class, GallimimusEntity.class, ProcompsognathusEntity.class, MetriacanthosaurusEntity.class, EuoplocephalusEntity.class, StyracosaurusEntity.class, MaiasauraEntity.class, MicroceratusEntity.class);
        socialGroupProperties.addScaredOf(TroodonEntity.class, TyrannosaurusEntity.class, BaryonyxEntity.class);
        socialGroupProperties.addHerdTargets(AchillobatorEntity.class, VelociraptorEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(7);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<AchillobatorEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(14071664, 6833696);
        itemProperties.setSpawnEggColorsMale(9536044, 8143903);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<AchillobatorEntity> attributes, EntityBaseProperties<AchillobatorEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(9.0);
        base.setSizeDimorphism(9.0);
        base.setTurnSmoothRate((double)0.45f);
        base.setRenderScale((double)0.76f);
        base.setLocator(new JSAnimalBaseLocator().setAdultOnly());
        base.setBabyAnimations();
        attributes.setPersistent();
        attributes.setEntityFactory(AchillobatorEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(50.0);
        attributes.setDimensions(0.75, (double)1.4f);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(12.0));
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier(3.25);
        attributes.setAttackDamage(15.0);
        attributes.setAttackSpeed(2.0);
        attributes.setAttackKnockback(0.5);
        attributes.setFollowRange(64.0);
    }
}

