/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class CoelurusAnimal
extends AbstractJSAnimal<VelociraptorEntity> {
    public CoelurusAnimal() {
        super("coelurus");
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<VelociraptorEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.87f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(new JSGene[0]);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<VelociraptorEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(2.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.setStalkingSpeedMultiplier(0.7f);
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<VelociraptorEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.setGuidebookScaling(new float[]{1.2f, 1.7f});
        miscProperties.setGuidebookOffset(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f));
        miscProperties.setExtinct();
        miscProperties.setVersion(2.0f);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<VelociraptorEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(Villager.class, Illusioner.class, Pillager.class, Player.class, Animal.class, GoatEntity.class, DryosaurusEntity.class, GallimimusEntity.class, ParasaurolophusEntity.class, HadrosaurusEntity.class, OstrichEntity.class, Llama.class, WanderingTrader.class);
        socialGroupProperties.addScaredOf(TroodonEntity.class, TyrannosaurusEntity.class);
        socialGroupProperties.addHerdTargets(VelociraptorEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(7);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<VelociraptorEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(14799547, 14699318);
        itemProperties.setSpawnEggColorsMale(15372650, 14367010);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<VelociraptorEntity> attributes, EntityBaseProperties<VelociraptorEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(9.0);
        base.setSizeDimorphism(9.0);
        base.setRenderScale((double)0.478f);
        base.setLocator(new JSAnimalBaseLocator());
        base.setBabyAnimations();
        attributes.setPersistent();
        attributes.setWaterEfficiency((double)0.6f);
        attributes.setEntityFactory(VelociraptorEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(50.0);
        attributes.setDimensions(0.75, (double)1.4f);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(12.0));
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier(3.25);
        attributes.setAttackDamage(15.0);
        attributes.setAttackSpeed(2.0);
        attributes.setAttackKnockback(0.5);
        attributes.setFollowRange(64.0);
    }
}

