/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class ProceratosaurusAnimal
extends AbstractJSAnimal<DryosaurusEntity> {
    public ProceratosaurusAnimal() {
        super("proceratosaurus");
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<DryosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.35f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(new JSGene[0]);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<DryosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(2.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<DryosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{1.1f, 0.3f});
        miscProperties.setGuidebookOffset(new Vec2(-2.0f, 0.0f), new Vec2(-1.0f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setVersion(2.0f);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<DryosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(TyrannosaurusEntity.class, VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class);
        socialGroupProperties.addHerdTargets(DryosaurusEntity.class);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
        socialGroupProperties.enableNesting();
    }

    @Override
    protected void applyItemProperties(JSItemProperties<DryosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(7037503, 7625012);
        itemProperties.setSpawnEggColorsMale(5913895, 3089690);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<DryosaurusEntity> attributes, EntityBaseProperties<DryosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setSizeDimorphism(9.0);
        base.setMaxTurnRate(0.25);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setRenderScale(0.5);
        base.setLocator(new JSAnimalBaseLocator());
        base.setTurnSmoothRate(1.0);
        attributes.setPersistent();
        attributes.setEntityFactory(DryosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(15.0);
        attributes.setDimensions((double)0.9f, (double)1.2f);
        attributes.setMovementSpeed((double)0.2f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)1.4f);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
    }
}

