/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.entity.extant.avian;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class ButterflyEntity
extends JSAvianBase {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ButterflyEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.entityData.set(VARIANT, (Object)this.random.nextInt(ButterflyVariant.values().length));
        this.moveController = this.flyingMoveControl;
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)1);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.entityData.set(VARIANT, (Object)this.random.nextInt(ButterflyVariant.values().length));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("js.butterfly.variant", ((Integer)this.entityData.get(VARIANT)).intValue());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(VARIANT, (Object)tag.getInt("js.butterfly.variant"));
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(6, 6));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 5));
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean shouldDieInstantly() {
        return true;
    }

    @Override
    public boolean disableFlyTransitions() {
        return true;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return this.getFlyingPathNavigation();
    }

    public int getMaxSpawnClusterSize() {
        return 40;
    }

    public ButterflyVariant getVariant() {
        return ButterflyVariant.fromId((Integer)this.entityData.get(VARIANT));
    }

    public static enum ButterflyVariant {
        BIRDWING(0, "birdwing"),
        TROPONOPTERA(1, "trogonoptera");

        private final String name;
        private final int id;

        private ButterflyVariant(int id, String name) {
            this.name = name;
            this.id = id;
        }

        public static ButterflyVariant fromId(int t) {
            for (ButterflyVariant value : ButterflyVariant.values()) {
                if (value.id != t) continue;
                return value;
            }
            return BIRDWING;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

