/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSOpenDoorTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatLeapTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import jp.jurassicsaga.server.v2.sound.JSV2Sounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class AchillobatorEntity
extends JSAnimalBase
implements IJSLeapingEntity {
    private int minLeapTicks = 0;

    public AchillobatorEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSOpenDoorTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(16, 9));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this).shouldCallout(true, 40).stalk());
        controller.registerTask((TravelerTaskBase)new JSCombatLeapTask(this, 0.5f));
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    protected int attackAnimLength() {
        return 20;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.isLeaping()) {
            if (this.minLeapTicks > 0) {
                --this.minLeapTicks;
            } else if (this.onGround() || this.isInWater()) {
                this.setLeaping(false);
            }
        }
    }

    @Override
    public double minDistance() {
        return 90.0;
    }

    @Override
    public double maxDistance() {
        return 100.0;
    }

    public double jumpHeight() {
        if (this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT && !this.isInWater()) {
            return 5.0;
        }
        return 1.0;
    }

    @Override
    public void onLeap() {
        if (this.getAttackSound() != null) {
            this.playSound(this.getAttackSound(), this.getSoundVolume(), 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        this.setLeaping(true);
        this.minLeapTicks = 1;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        JSGroundNavigation nav = new JSGroundNavigation(this, level);
        nav.setCanOpenDoors(true);
        nav.setCanPassDoors(true);
        return nav;
    }

    @Override
    @Nullable
    protected SoundEvent getAttackSound() {
        return (SoundEvent)JSV2Sounds.ACHILLOBATOR_ATTACK.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getTarget() != null) {
            return (SoundEvent)JSV2Sounds.ACHILLOBATOR_THREAT.get();
        }
        return (SoundEvent)JSV2Sounds.ACHILLOBATOR_LIVING.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSV2Sounds.ACHILLOBATOR_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)JSV2Sounds.ACHILLOBATOR_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return (SoundEvent)JSV2Sounds.ACHILLOBATOR_BARK.get();
    }
}

