/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAmphibiousBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRoarTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v2.sound.JSV2Sounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;
import travelers.server.animal.obj.animation.TravelersSoundAnimationDefinition;

public class BaryonyxEntity
extends JSAmphibiousBase {
    public BaryonyxEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(18, 9));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSRoarTask(this, new TravelersSoundAnimationDefinition((SoundEvent)JSV2Sounds.BARYONYX_ROAR.get(), JSAnimations.ROAR_1, 65, 0, 0)).scareNearby());
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    protected int attackAnimLength() {
        return 20;
    }

    @Override
    protected boolean usesAir() {
        return false;
    }

    @Override
    public boolean shallowSwimming() {
        return true;
    }

    @Override
    protected boolean sinkToBottom() {
        return false;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getTarget() != null || this.getFleeTarget() != null) {
            return (SoundEvent)JSV2Sounds.BARYONYX_ROAR.get();
        }
        return (SoundEvent)JSV2Sounds.BARYONYX_LIVING.get();
    }

    @Override
    @Nullable
    protected SoundEvent getAttackSound() {
        return (SoundEvent)JSV2Sounds.BARYONYX_ATTACK.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSV2Sounds.BARYONYX_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)JSV2Sounds.BARYONYX_HURT.get();
    }
}

