/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block;

import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.function.Consumer;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.block.obj.JSTransparentBlock;
import jp.jurassicsaga.server.base.block.obj.fence.PoleBlock;
import jp.jurassicsaga.server.base.block.obj.group.StoneRegistries;
import jp.jurassicsaga.server.base.block.obj.group.WoodRegistries;
import jp.jurassicsaga.server.base.block.obj.plant.JSAquaticPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.JSDoublePlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.JSTallPlantBlock;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSDoor;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSSapling;
import jp.jurassicsaga.server.base.block.obj.vanilla_overrides.JSWaterLily;
import jp.jurassicsaga.server.v2.block.obj.BinBlock;
import jp.jurassicsaga.server.v2.block.obj.CustomBubbleColumnBlock;
import jp.jurassicsaga.server.v2.block.obj.DogwoodLeaves;
import jp.jurassicsaga.server.v2.block.obj.FumaroleBlock;
import jp.jurassicsaga.server.v2.block.obj.GeyserBlock;
import jp.jurassicsaga.server.v2.block.obj.JSMudBlock;
import jp.jurassicsaga.server.v2.block.obj.JSMushroomBlock;
import jp.jurassicsaga.server.v2.block.obj.VolcanicMagmaBlock;
import jp.jurassicsaga.server.v2.block.obj.WireBlock;
import jp.jurassicsaga.server.v2.world.tree.JSV2TreeGrowers;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class JSV2Blocks {
    public static final Supplier<Block> MUD = JSBlocks.registerBlockWItem("wet_mud", (Supplier<Block>)((Supplier)() -> new JSMudBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COARSE_DIRT))), new Item.Properties());
    public static final Supplier<Block> VOLCANIC_MAGMA = JSBlocks.registerBlockWItem("volcanic_magma", (Supplier<Block>)((Supplier)() -> new VolcanicMagmaBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MAGMA_BLOCK).lightLevel(a -> 10))), new Item.Properties());
    public static final Supplier<Block> CUSTOM_BUBBLE_BLOCK = JSBlocks.registerBlock("bubble_block", (Supplier<Block>)((Supplier)() -> new CustomBubbleColumnBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BUBBLE_COLUMN))));
    public static final Supplier<Block> GEYSER_BLOCK = JSBlocks.registerBlockWItem("geyser", (Supplier<Block>)((Supplier)() -> new GeyserBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.STONE))), new Item.Properties());
    public static final Supplier<Block> FUMAROLE = JSBlocks.registerBlockWItem("fumarole", (Supplier<Block>)((Supplier)() -> new FumaroleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.STONE))), new Item.Properties());
    public static final Supplier<Block> VOLCANIC_ROCK = JSBlocks.registerBlockWItem("volcanic_rock", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE))), new Item.Properties());
    public static final Supplier<Block> DEAD_WOOD = JSBlocks.registerBlockWItem("deadwood_log", (Supplier<Block>)((Supplier)() -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).strength(0.5f, 0.1f))), new Item.Properties());
    public static final Supplier<Block> BURNING_LOG = JSBlocks.registerBlockWItem("burning_log", (Supplier<Block>)((Supplier)() -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).lightLevel(a -> 6).strength(1.0f, 0.2f))), new Item.Properties());
    public static final Supplier<Block> BURNT_LOG = JSBlocks.registerBlockWItem("burnt_log", (Supplier<Block>)((Supplier)() -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).strength(0.5f, 0.1f))), new Item.Properties());
    public static final Supplier<Block> ASH = JSBlocks.registerBlockWItem("ash", (Supplier<Block>)((Supplier)() -> new ColoredFallingBlock(new ColorRGBA(6381663), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAVEL))), new Item.Properties());
    public static final Supplier<Block> SCORCHED_EARTH = JSBlocks.registerBlockWItem("scorched_earth", (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK))), new Item.Properties());
    public static final Supplier<Block> BIN = JSBlocks.registerBlockWItem("bin", (Supplier<Block>)((Supplier)BinBlock::new), new Item.Properties());
    public static final Supplier<Block> AMBER_BLOCK = JSBlocks.registerBlockWItem("amber_block", (Supplier<Block>)((Supplier)() -> new JSTransparentBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).sound(SoundType.DRIPSTONE_BLOCK).noOcclusion(), false)), new Item.Properties());
    public static final Supplier<Block> LAB_DOOR = JSBlocks.registerBlockWItem("lab_door", (Supplier<Block>)((Supplier)() -> new JSDoor(BlockSetType.COPPER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_DOOR))), new Item.Properties());
    public static final Supplier<Block> HIGH_SECURITY_DOOR = JSBlocks.registerBlockWItem("high_security_door", (Supplier<Block>)((Supplier)() -> new JSDoor(BlockSetType.IRON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_DOOR).strength(6.0f))), new Item.Properties());
    public static final StoneRegistries SHALE = new StoneRegistries("shale", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries POLISHED_SHALE = new StoneRegistries("polished_shale", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries MOSSY_POLISHED_SHALE = new StoneRegistries("mossy_polished_shale", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries SHALE_BRICKS = new StoneRegistries("shale_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries MOSSY_SHALE_BRICKS = new StoneRegistries("mossy_shale_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries INTRICATE_SHALE_BRICKS = new StoneRegistries("intricate_shale_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries MOSSY_INTRICATE_SHALE_BRICKS = new StoneRegistries("mossy_intricate_shale_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries RHYOLITE = new StoneRegistries("rhyolite", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries POLISHED_RHYOLITE = new StoneRegistries("polished_rhyolite", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries MOSSY_POLISHED_RHYOLITE = new StoneRegistries("mossy_polished_rhyolite", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries RHYOLITE_BRICKS = new StoneRegistries("rhyolite_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries MOSSY_RHYOLITE_BRICKS = new StoneRegistries("mossy_rhyolite_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries INTRICATE_RHYOLITE_BRICKS = new StoneRegistries("intricate_rhyolite_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final StoneRegistries MOSSY_INTRICATE_RHYOLITE_BRICKS = new StoneRegistries("mossy_intricate_rhyolite_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), new Item.Properties());
    public static final WoodRegistries DOG_WOOD = new WoodRegistries("dogwood", MapColor.COLOR_BROWN, new Item.Properties()){

        @Override
        public Block leaves() {
            return new DogwoodLeaves(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn((pState, pLevel, pPos, pValue) -> pValue == EntityType.OCELOT || pValue == EntityType.PARROT).isSuffocating((pState, pLevel, pPos) -> false).isViewBlocking((pState, pLevel, pPos) -> false).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor((pState, pLevel, pPos) -> false));
        }
    };
    public static final Supplier<Block> DOG_WOOD_SAPLING = JSBlocks.registerBlockWItem("dogwood_sapling", (Supplier<Block>)((Supplier)() -> new JSSapling(JSV2TreeGrowers.DOG_WOOD, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_SAPLING))), new Item.Properties());
    public static final Supplier<Block> BRASENITES_KANSENSE_BASIC = JSBlocks.registerLilypad("brasenites_kansense_basic", (Supplier<Block>)((Supplier)() -> new JSWaterLily(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).noCollission())), new Item.Properties());
    public static final Supplier<Block> BRASENITES_KANSENSE_BLUE = JSBlocks.registerLilypad("brasenites_kansense_blue", (Supplier<Block>)((Supplier)() -> new JSWaterLily(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).noCollission())), new Item.Properties());
    public static final Supplier<Block> BRASENITES_KANSENSE_LIGHTBLUE = JSBlocks.registerLilypad("brasenites_kansense_lightblue", (Supplier<Block>)((Supplier)() -> new JSWaterLily(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).noCollission())), new Item.Properties());
    public static final Supplier<Block> BRASENITES_KANSENSE_MAGENTA = JSBlocks.registerLilypad("brasenites_kansense_magenta", (Supplier<Block>)((Supplier)() -> new JSWaterLily(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).noCollission())), new Item.Properties());
    public static final Supplier<Block> BRASENITES_KANSENSE_ORANGE = JSBlocks.registerLilypad("brasenites_kansense_orange", (Supplier<Block>)((Supplier)() -> new JSWaterLily(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).noCollission())), new Item.Properties());
    public static final Supplier<Block> BRASENITES_KANSENSE_PINK = JSBlocks.registerLilypad("brasenites_kansense_pink", (Supplier<Block>)((Supplier)() -> new JSWaterLily(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).noCollission())), new Item.Properties());
    public static final Supplier<Block> BRASENITES_KANSENSE_RED = JSBlocks.registerLilypad("brasenites_kansense_red", (Supplier<Block>)((Supplier)() -> new JSWaterLily(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).noCollission())), new Item.Properties());
    public static final Supplier<Block> BRASENITES_KANSENSE_YELLOW = JSBlocks.registerLilypad("brasenites_kansense_yellow", (Supplier<Block>)((Supplier)() -> new JSWaterLily(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).noCollission())), new Item.Properties());
    public static final Supplier<Block> MONTSECHIA = JSBlocks.registerBlockWItem("montsechia", (Supplier<Block>)((Supplier)() -> new JSAquaticPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEAGRASS))), new Item.Properties());
    public static final Supplier<Block> NATHORSTIANA = JSBlocks.registerBlockWItem("nathorstiana", (Supplier<Block>)((Supplier)() -> new JSAquaticPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEAGRASS))), new Item.Properties());
    public static final Supplier<Block> ORONTIUM_MACKII = JSBlocks.registerBlockWItem("orontium_mackii", (Supplier<Block>)((Supplier)() -> new JSAquaticPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEAGRASS))), new Item.Properties());
    public static final Supplier<Block> GONDWANAGARICITES = JSBlocks.registerBlockWItem("gondwanagaricites", (Supplier<Block>)((Supplier)() -> new JSMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> MABELIA_BASIC = JSBlocks.registerBlockWItem("mabelia_basic", (Supplier<Block>)((Supplier)() -> new JSMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> MABELIA_LIGHTBLUE = JSBlocks.registerBlockWItem("mabelia_lightblue", (Supplier<Block>)((Supplier)() -> new JSMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> MABELIA_ORANGE = JSBlocks.registerBlockWItem("mabelia_orange", (Supplier<Block>)((Supplier)() -> new JSMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> MABELIA_PINK = JSBlocks.registerBlockWItem("mabelia_pink", (Supplier<Block>)((Supplier)() -> new JSMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> MABELIA_RED = JSBlocks.registerBlockWItem("mabelia_red", (Supplier<Block>)((Supplier)() -> new JSMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> MABELIA_WHITE = JSBlocks.registerBlockWItem("mabelia_white", (Supplier<Block>)((Supplier)() -> new JSMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> MABELIA_YELLOW = JSBlocks.registerBlockWItem("mabelia_yellow", (Supplier<Block>)((Supplier)() -> new JSMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> PLEUROMEIA = JSBlocks.registerBlockWItem("pleuromeia", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> WILLIAMSONIA = JSBlocks.registerBlockWItem("williamsonia", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> ZAMITES = JSBlocks.registerBlockWItem("zamites", (Supplier<Block>)((Supplier)() -> new JSDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> DICKSONIA = JSBlocks.registerBlockWItem("dicksonia", (Supplier<Block>)((Supplier)() -> new JSTallPlantBlock(5, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> DICROIDIUM = JSBlocks.registerBlockWItem("dicroidium", (Supplier<Block>)((Supplier)() -> new JSTallPlantBlock(5, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> SCALY_TREE_FERN = JSBlocks.registerBlockWItem("scaly_tree_fern", (Supplier<Block>)((Supplier)() -> new JSTallPlantBlock(8, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM))), new Item.Properties());
    public static final Supplier<Block> POLE = JSBlocks.registerBlockWItem("pole", (Supplier<Block>)((Supplier)() -> new PoleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).dynamicShape())), new Item.Properties());
    public static final Supplier<Block> WIRE_BLOCK = JSBlocks.registerBlockWItem("wire_block", (Supplier<Block>)((Supplier)WireBlock::new), new Item.Properties());

    public static Runnable addBlocks(Consumer<ItemLike> output) {
        return () -> {
            output.accept((ItemLike)MUD.get());
            output.accept((ItemLike)VOLCANIC_MAGMA.get());
            output.accept((ItemLike)GEYSER_BLOCK.get());
            output.accept((ItemLike)FUMAROLE.get());
            output.accept((ItemLike)VOLCANIC_ROCK.get());
            output.accept((ItemLike)DEAD_WOOD.get());
            output.accept((ItemLike)BURNING_LOG.get());
            output.accept((ItemLike)BURNT_LOG.get());
            output.accept((ItemLike)ASH.get());
            output.accept((ItemLike)SCORCHED_EARTH.get());
            output.accept((ItemLike)BIN.get());
            output.accept((ItemLike)LAB_DOOR.get());
            output.accept((ItemLike)HIGH_SECURITY_DOOR.get());
            output.accept((ItemLike)AMBER_BLOCK.get());
            SHALE.accept(output);
            POLISHED_SHALE.accept(output);
            MOSSY_POLISHED_SHALE.accept(output);
            SHALE_BRICKS.accept(output);
            MOSSY_SHALE_BRICKS.accept(output);
            INTRICATE_SHALE_BRICKS.accept(output);
            MOSSY_INTRICATE_SHALE_BRICKS.accept(output);
            RHYOLITE.accept(output);
            POLISHED_RHYOLITE.accept(output);
            MOSSY_POLISHED_RHYOLITE.accept(output);
            RHYOLITE_BRICKS.accept(output);
            MOSSY_RHYOLITE_BRICKS.accept(output);
            INTRICATE_RHYOLITE_BRICKS.accept(output);
            MOSSY_INTRICATE_RHYOLITE_BRICKS.accept(output);
        };
    }

    public static Runnable addPlants(Consumer<ItemLike> output) {
        return () -> {
            output.accept((ItemLike)BRASENITES_KANSENSE_BASIC.get());
            output.accept((ItemLike)BRASENITES_KANSENSE_BLUE.get());
            output.accept((ItemLike)BRASENITES_KANSENSE_LIGHTBLUE.get());
            output.accept((ItemLike)BRASENITES_KANSENSE_MAGENTA.get());
            output.accept((ItemLike)BRASENITES_KANSENSE_ORANGE.get());
            output.accept((ItemLike)BRASENITES_KANSENSE_PINK.get());
            output.accept((ItemLike)BRASENITES_KANSENSE_RED.get());
            output.accept((ItemLike)BRASENITES_KANSENSE_YELLOW.get());
            output.accept((ItemLike)MONTSECHIA.get());
            output.accept((ItemLike)NATHORSTIANA.get());
            output.accept((ItemLike)ORONTIUM_MACKII.get());
            output.accept((ItemLike)GONDWANAGARICITES.get());
            output.accept((ItemLike)MABELIA_BASIC.get());
            output.accept((ItemLike)MABELIA_LIGHTBLUE.get());
            output.accept((ItemLike)MABELIA_ORANGE.get());
            output.accept((ItemLike)MABELIA_PINK.get());
            output.accept((ItemLike)MABELIA_RED.get());
            output.accept((ItemLike)MABELIA_WHITE.get());
            output.accept((ItemLike)MABELIA_YELLOW.get());
            output.accept((ItemLike)PLEUROMEIA.get());
            output.accept((ItemLike)WILLIAMSONIA.get());
            output.accept((ItemLike)ZAMITES.get());
            output.accept((ItemLike)DICKSONIA.get());
            output.accept((ItemLike)DICROIDIUM.get());
            output.accept((ItemLike)SCALY_TREE_FERN.get());
            output.accept((ItemLike)DOG_WOOD_SAPLING.get());
            JSV2Blocks.addToOutput(DOG_WOOD.collect(), output);
        };
    }

    private static void addToOutput(Collection<ItemLike> collect, Consumer<ItemLike> output) {
        for (ItemLike itemLike : collect) {
            output.accept(itemLike);
        }
    }

    public static void init() {
    }
}

