/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.entity.obj;

import java.util.ArrayList;
import java.util.List;
import jp.jurassicsaga.server.v2.block.entity.JSV2BlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WireBlockEntity
extends BlockEntity {
    @Nullable
    private BlockPos connectionA = null;
    @Nullable
    private BlockPos connectionB = null;
    private Vec3 preferredDir = new Vec3(1.0, 0.0, 0.0);
    private VoxelShape cachedShape = Shapes.block();

    public WireBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)JSV2BlockEntities.WIRE.get(), pos, state);
    }

    public void updateConnections() {
        Vec3 dir;
        double dist;
        Vec3 delta;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.connectionA = null;
        this.connectionB = null;
        Vec3 myCenter = Vec3.atCenterOf((Vec3i)this.worldPosition);
        double radius = 2.5;
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.worldPosition.offset(-2, -2, -2), (BlockPos)this.worldPosition.offset(2, 2, 2))) {
            BlockEntity be;
            if (pos.equals((Object)this.worldPosition) || !((be = this.level.getBlockEntity(pos)) instanceof WireBlockEntity)) continue;
            candidates.add(pos.immutable());
        }
        if (candidates.isEmpty()) {
            this.rebuildShapeCache();
            return;
        }
        Vec3 bestDirA = null;
        Vec3 bestDirB = null;
        double bestDistA = Double.MAX_VALUE;
        double bestDistB = Double.MAX_VALUE;
        for (BlockPos pos : candidates) {
            delta = Vec3.atCenterOf((Vec3i)pos).subtract(myCenter);
            dist = delta.length();
            if (dist > radius) continue;
            dir = delta.normalize();
            if (Math.abs(dir.y) > 0.7 || !(dist < bestDistA)) continue;
            bestDistA = dist;
            bestDirA = dir;
            this.connectionA = pos;
        }
        if (bestDirA != null) {
            this.preferredDir = bestDirA;
        }
        for (BlockPos pos : candidates) {
            double dot;
            if (pos.equals((Object)this.connectionA) || (dist = (delta = Vec3.atCenterOf((Vec3i)pos).subtract(myCenter)).length()) > radius || !((dot = this.preferredDir.dot(dir = delta.normalize())) < -0.6) || !(dist < bestDistB)) continue;
            bestDistB = dist;
            bestDirB = dir;
            this.connectionB = pos;
        }
        this.rebuildShapeCache();
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public void rebuildShapeCache() {
        VoxelShape shape = Shapes.box((double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6);
        Vec3 center = Vec3.atCenterOf((Vec3i)this.worldPosition);
        if (this.connectionA != null) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)this.createWireAABB(center, Vec3.atCenterOf((Vec3i)this.connectionA), 0.1)));
        }
        if (this.connectionB != null) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)this.createWireAABB(center, Vec3.atCenterOf((Vec3i)this.connectionB), 0.1)));
        }
        this.cachedShape = shape.optimize();
    }

    private AABB createWireAABB(Vec3 from, Vec3 to, double radius) {
        double minX = Math.min(from.x, to.x) - radius;
        double minY = Math.min(from.y, to.y) - radius;
        double minZ = Math.min(from.z, to.z) - radius;
        double maxX = Math.max(from.x, to.x) + radius;
        double maxY = Math.max(from.y, to.y) + radius;
        double maxZ = Math.max(from.z, to.z) + radius;
        return new AABB(minX - from.x + 0.5, minY - from.y + 0.5, minZ - from.z + 0.5, maxX - from.x + 0.5, maxY - from.y + 0.5, maxZ - from.z + 0.5);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.connectionA != null) {
            tag.putLong("connA", this.connectionA.asLong());
        }
        if (this.connectionB != null) {
            tag.putLong("connB", this.connectionB.asLong());
        }
        tag.put("dir", (Tag)WireBlockEntity.saveVec(this.preferredDir));
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.connectionA = tag.contains("connA") ? BlockPos.of((long)tag.getLong("connA")) : null;
        this.connectionB = tag.contains("connB") ? BlockPos.of((long)tag.getLong("connB")) : null;
        this.preferredDir = WireBlockEntity.loadVec(tag.getCompound("dir"));
        if (this.level != null && this.level.isClientSide) {
            this.rebuildShapeCache();
        }
    }

    private static CompoundTag saveVec(Vec3 v) {
        CompoundTag t = new CompoundTag();
        t.putDouble("x", v.x);
        t.putDouble("y", v.y);
        t.putDouble("z", v.z);
        return t;
    }

    private static Vec3 loadVec(CompoundTag t) {
        return new Vec3(t.getDouble("x"), t.getDouble("y"), t.getDouble("z"));
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public List<Vec3> getConnectionCenters() {
        ArrayList<Vec3> list = new ArrayList<Vec3>();
        if (this.connectionA != null) {
            list.add(Vec3.atCenterOf((Vec3i)this.connectionA));
        }
        if (this.connectionB != null) {
            list.add(Vec3.atCenterOf((Vec3i)this.connectionB));
        }
        return list;
    }

    @Nullable
    public BlockPos getConnectionA() {
        return this.connectionA;
    }

    @Nullable
    public BlockPos getConnectionB() {
        return this.connectionB;
    }

    public Vec3 getPreferredDir() {
        return this.preferredDir;
    }

    public VoxelShape getCachedShape() {
        return this.cachedShape;
    }
}

