/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.obj;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomBubbleColumnBlock
extends Block
implements BucketPickup {
    public static final MapCodec<BubbleColumnBlock> CODEC = CustomBubbleColumnBlock.simpleCodec(BubbleColumnBlock::new);
    public static final BooleanProperty DRAG_DOWN = BlockStateProperties.DRAG;
    private static final int CHECK_PERIOD = 5;

    @NotNull
    public MapCodec<BubbleColumnBlock> codec() {
        return CODEC;
    }

    public CustomBubbleColumnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DRAG_DOWN, (Comparable)Boolean.valueOf(true)));
    }

    protected void entityInside(@NotNull BlockState state, Level level, BlockPos pos, @NotNull Entity entity) {
        BlockState blockstate = level.getBlockState(pos.above());
        if (blockstate.isAir()) {
            entity.onAboveBubbleCol(((Boolean)state.getValue((Property)DRAG_DOWN)).booleanValue());
            if (!level.isClientSide) {
                ServerLevel serverlevel = (ServerLevel)level;
                for (int i = 0; i < 2; ++i) {
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + level.random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + level.random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + level.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else {
            entity.onInsideBubbleColumn(((Boolean)state.getValue((Property)DRAG_DOWN)).booleanValue());
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        CustomBubbleColumnBlock.updateColumn((LevelAccessor)level, pos, state, level.getBlockState(pos.below()));
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        return Fluids.WATER.getSource(false);
    }

    public static void updateColumn(LevelAccessor level, BlockPos pos, BlockState state) {
        CustomBubbleColumnBlock.updateColumn(level, pos, level.getBlockState(pos), state);
    }

    public static void updateColumn(LevelAccessor level, BlockPos pos, BlockState fluid, BlockState state) {
        if (CustomBubbleColumnBlock.canExistIn(fluid)) {
            BlockState blockstate = CustomBubbleColumnBlock.getColumnState(state);
            level.setBlock(pos, blockstate, 2);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable().move(Direction.UP);
            while (CustomBubbleColumnBlock.canExistIn(level.getBlockState((BlockPos)blockpos$mutableblockpos))) {
                if (!level.setBlock((BlockPos)blockpos$mutableblockpos, blockstate, 2)) {
                    return;
                }
                blockpos$mutableblockpos.move(Direction.UP);
            }
        }
    }

    private static boolean canExistIn(BlockState blockState) {
        return blockState.is((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get()) || blockState.is(Blocks.WATER) && blockState.getFluidState().getAmount() >= 8 && blockState.getFluidState().isSource();
    }

    private static BlockState getColumnState(BlockState blockState) {
        if (blockState.is((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get())) {
            return blockState;
        }
        return blockState.is((Block)JSV2Blocks.VOLCANIC_MAGMA.get()) ? (BlockState)((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get()).defaultBlockState().setValue((Property)DRAG_DOWN, (Comparable)Boolean.valueOf(true)) : Blocks.WATER.defaultBlockState();
    }

    public void animateTick(BlockState state, @NotNull Level level, BlockPos pos, @NotNull RandomSource random) {
        double d0 = pos.getX();
        double d1 = pos.getY();
        double d2 = pos.getZ();
        if (((Boolean)state.getValue((Property)DRAG_DOWN)).booleanValue()) {
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CURRENT_DOWN, d0 + 0.5, d1 + 0.8, d2, 0.0, 0.0, 0.0);
            if (random.nextInt(200) == 0) {
                level.playLocalSound(d0, d1, d2, SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        } else {
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, d0 + 0.5, d1, d2 + 0.5, 0.0, 0.04, 0.0);
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, d0 + (double)random.nextFloat(), d1 + (double)random.nextFloat(), d2 + (double)random.nextFloat(), 0.0, 0.04, 0.0);
            if (random.nextInt(200) == 0) {
                level.playLocalSound(d0, d1, d2, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        if (!state.canSurvive((LevelReader)level, currentPos) || facing == Direction.DOWN || facing == Direction.UP && !facingState.is((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get()) && CustomBubbleColumnBlock.canExistIn(facingState)) {
            level.scheduleTick(currentPos, (Block)this, 5);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.below());
        return blockstate.is((Block)JSV2Blocks.CUSTOM_BUBBLE_BLOCK.get()) || blockstate.is((Block)JSV2Blocks.VOLCANIC_MAGMA.get());
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DRAG_DOWN});
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        return new ItemStack((ItemLike)Items.WATER_BUCKET);
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }
}

