/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.obj;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import jp.jurassicsaga.server.base.particle.JSParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class GeyserBlock
extends Block {
    public static final int ERUPT_INTERVAL = 1000;
    public static final IntegerProperty HEIGHT = IntegerProperty.create((String)"height", (int)8, (int)16);

    public GeyserBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HEIGHT, (Comparable)Integer.valueOf(8)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HEIGHT});
    }

    public void onPlace(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 1000);
        }
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (random.nextInt(5) == 0) {
            double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.4;
            double y = (double)pos.getY() + 0.1;
            double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.4;
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, 0.0, 0.06, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y + 0.2, z, 0.0, 0.03, 0.0);
        }
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int height = (Integer)state.getValue((Property)HEIGHT);
        this.spawnWaterColumn(height, state, level, pos);
        level.playSound(null, pos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 1.5f, 1.0f);
        level.scheduleTick(pos, (Block)this, 1000 + level.random.nextInt(60));
    }

    private void spawnWaterColumn(int height, @NotNull BlockState state, ServerLevel level, BlockPos pos) {
        CompletableFuture.runAsync(() -> {
            for (int i = 1; i <= height; ++i) {
                BlockPos wp = pos.above(i);
                if (!level.isEmptyBlock(wp) && !level.getBlockState(wp).is(Blocks.WATER)) continue;
                level.getServer().execute(() -> {
                    if (level.getServer().isStopped() || !level.getServer().isRunning()) {
                        return;
                    }
                    level.setBlock(wp, Blocks.WATER.defaultBlockState(), 3);
                    AABB area = new AABB(pos).inflate(1.6, (double)(height + 1), 1.6);
                    for (Entity e : level.getEntities(null, area)) {
                        e.setDeltaMovement(e.getDeltaMovement().add(0.0, 0.3, 0.0));
                        e.hurtMarked = true;
                    }
                    CompletableFuture.runAsync(() -> level.getServer().execute(() -> level.setBlock(wp, Blocks.AIR.defaultBlockState(), 3)), CompletableFuture.delayedExecutor(400L, TimeUnit.MILLISECONDS));
                    level.sendParticles((ParticleOptions)JSParticles.STEAM.get(), (double)wp.getX() + level.random.nextDouble(), (double)(wp.getY() + 1), (double)wp.getZ() + level.random.nextDouble(), 10, 0.0, 0.01, 0.0, 0.1);
                });
                try {
                    Thread.sleep(150L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }
}

