/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.obj;

import jp.jurassicsaga.server.base.particle.JSParticles;
import jp.jurassicsaga.server.v2.block.obj.CustomBubbleColumnBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class VolcanicMagmaBlock
extends Block {
    public VolcanicMagmaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void stepOn(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, Entity entity) {
        if (!entity.isSteppingCarefully() && entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, BlockPos pos, @NotNull RandomSource random) {
        CustomBubbleColumnBlock.updateColumn((LevelAccessor)level, pos.above(), state);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (direction == Direction.UP && neighborState.is(Blocks.WATER)) {
            level.scheduleTick(pos, (Block)this, 20);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void animateTick(@NotNull BlockState state, Level level, BlockPos pos, @NotNull RandomSource random) {
        if (!level.getBlockState(pos.above()).getFluidState().isSourceOfType((Fluid)Fluids.WATER)) {
            return;
        }
        float randomX = random.nextFloat() * 0.1f;
        float randomZ = random.nextFloat() * 0.1f;
        level.addParticle((ParticleOptions)JSParticles.STEAM.get(), true, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, (double)(randomX -= random.nextFloat() * 0.1f), 0.1 + (double)(random.nextFloat() * 0.1f), (double)(randomZ -= random.nextFloat() * 0.1f));
    }

    protected void onPlace(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 20);
    }
}

