/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.obj;

import java.util.Map;
import jp.jurassicsaga.server.base.block.obj.fence.PoleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WireBlock
extends Block {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    protected static final VoxelShape CENTER = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NORTH_ARM = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0);
    protected static final VoxelShape SOUTH_ARM = Block.box((double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_ARM = Block.box((double)0.0, (double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0);
    protected static final VoxelShape EAST_ARM = Block.box((double)9.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST);

    public WireBlock() {
        super(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).noOcclusion().isRedstoneConductor((a, b, c) -> false).pushReaction(PushReaction.IGNORE).noTerrainParticles());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(level.getBlockState(pos.north()))))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(level.getBlockState(pos.east()))))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(level.getBlockState(pos.south()))))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(level.getBlockState(pos.west()))));
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (dir.getAxis().isHorizontal()) {
            boolean connected = this.connectsTo(neighbor);
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(connected));
        }
        return state;
    }

    private boolean connectsTo(BlockState state) {
        return state.getBlock() instanceof WireBlock || state.getBlock() instanceof PoleBlock;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        VoxelShape shape = CENTER;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_ARM);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_ARM);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_ARM);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_ARM);
        }
        return shape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getShape(state, level, pos, ctx);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

