/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.entity.obj;

import jp.jurassicsaga.server.base.block.obj.fence.PoleBlock;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FenceCable
extends Entity {
    private static final EntityDataAccessor<Float> DATA_LENGTH = SynchedEntityData.defineId(FenceCable.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<BlockPos> LINK1 = SynchedEntityData.defineId(FenceCable.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<BlockPos> LINK2 = SynchedEntityData.defineId(FenceCable.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Integer> CABLE_TYPE_ID = SynchedEntityData.defineId(FenceCable.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean init = true;

    public FenceCable(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public void tick() {
        BlockState type;
        BlockState type2;
        if (this.getDataLength() < 1.0f) {
            this.discard();
            return;
        }
        BlockPos pos1 = this.getLink1();
        BlockPos pos2 = this.getLink2();
        boolean connected1 = false;
        if (pos1 != BlockPos.ZERO && (type2 = this.level().getBlockState(pos1)).is((Block)JSV2Blocks.POLE.get())) {
            connected1 = (Boolean)type2.getValue((Property)PoleBlock.POWERED);
        }
        boolean isPowered = false;
        if (pos2 != BlockPos.ZERO && connected1 && (type = this.level().getBlockState(pos2)).is((Block)JSV2Blocks.POLE.get())) {
            isPowered = (Boolean)type.getValue((Property)PoleBlock.POWERED);
        }
        super.tick();
        if (isPowered) {
            for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.1), e -> e instanceof LivingEntity || e instanceof Player)) {
                entity.hurt(this.level().damageSources().lightningBolt(), 1.0f);
            }
        }
    }

    public BlockPos getLink1() {
        return (BlockPos)this.entityData.get(LINK1);
    }

    public BlockPos getLink2() {
        return (BlockPos)this.entityData.get(LINK2);
    }

    public boolean isPickable() {
        return true;
    }

    @NotNull
    protected AABB makeBoundingBox() {
        return super.makeBoundingBox();
    }

    public void handleDamageEvent(@NotNull DamageSource damageSource) {
        this.kill();
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_LENGTH, (Object)Float.valueOf(0.0f));
        builder.define(CABLE_TYPE_ID, (Object)1);
        builder.define(LINK1, (Object)BlockPos.ZERO);
        builder.define(LINK2, (Object)BlockPos.ZERO);
    }

    public void setLink1(BlockPos link1) {
        this.entityData.set(LINK1, (Object)link1);
    }

    public void setLink2(BlockPos link2) {
        this.entityData.set(LINK2, (Object)link2);
    }

    public void setDataLength(float length) {
        this.entityData.set(DATA_LENGTH, (Object)Float.valueOf(length));
    }

    public float getDataLength() {
        return ((Float)this.entityData.get(DATA_LENGTH)).floatValue();
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setDataLength(compound.getFloat("fence.data_length"));
        if (compound.contains("fence.link1_x")) {
            this.setLink1(new BlockPos(compound.getInt("fence.link1_x"), compound.getInt("fence.link1_y"), compound.getInt("fence.link1_z")));
        }
        if (compound.contains("fence.link2_x")) {
            this.setLink2(new BlockPos(compound.getInt("fence.link2_x"), compound.getInt("fence.link2_y"), compound.getInt("fence.link2_z")));
        }
        this.entityData.set(CABLE_TYPE_ID, (Object)compound.getInt("fence.cable_type"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("fence.data_length", ((Float)this.entityData.get(DATA_LENGTH)).floatValue());
        BlockPos pos1 = (BlockPos)this.entityData.get(LINK1);
        compound.putInt("fence.link1_x", pos1.getX());
        compound.putInt("fence.link1_y", pos1.getY());
        compound.putInt("fence.link1_z", pos1.getZ());
        BlockPos pos2 = (BlockPos)this.entityData.get(LINK1);
        compound.putInt("fence.link2_x", pos2.getX());
        compound.putInt("fence.link2_y", pos2.getY());
        compound.putInt("fence.link2_z", pos2.getZ());
        compound.putInt("fence.cable_type", ((Integer)this.entityData.get(CABLE_TYPE_ID)).intValue());
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isConnectedTo(BlockPos pos) {
        return ((BlockPos)this.entityData.get(LINK1)).equals((Object)pos) || ((BlockPos)this.entityData.get(LINK2)).equals((Object)pos);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        BlockPos pos1 = (BlockPos)this.entityData.get(LINK1);
        BlockPos pos2 = (BlockPos)this.entityData.get(LINK1);
        BlockState type = this.level().getBlockState(pos1);
        if (type.is((Block)JSV2Blocks.POLE.get())) {
            type.setValue((Property)PoleBlock.CONNECTED, (Comparable)Boolean.valueOf(false));
        }
        if ((type = this.level().getBlockState(pos2)).is((Block)JSV2Blocks.POLE.get())) {
            type.setValue((Property)PoleBlock.CONNECTED, (Comparable)Boolean.valueOf(false));
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        this.kill();
        return true;
    }
}

