/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.item.obj;

import jp.jurassicsaga.server.base.block.obj.fence.PoleBlock;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import jp.jurassicsaga.server.v2.block.obj.WireBlock;
import jp.jurassicsaga.server.v2.entity.JSV2Entities;
import jp.jurassicsaga.server.v2.entity.obj.FenceCable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WireItem
extends Item {
    private final int linkLength = 80;

    public WireItem() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockState state = level.getBlockState(context.getClickedPos());
        if (state.is((Block)JSV2Blocks.POLE.get())) {
            if (!((Boolean)state.getValue((Property)PoleBlock.CONNECTED)).booleanValue()) {
                BlockPos pos1 = (BlockPos)context.getItemInHand().get((DataComponentType)JSDataComponents.POSITION.get());
                if (pos1 != null && pos1 != context.getClickedPos()) {
                    this.tryCreateLinkBetween(context, pos1, 80.0, context.getClickedPos());
                }
                context.getItemInHand().set((DataComponentType)JSDataComponents.POSITION.get(), (Object)new BlockPos((Vec3i)context.getClickedPos()));
            } else {
                Player player;
                if (!context.getLevel().isClientSide && (player = context.getPlayer()) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    MutableComponent textComponent = Component.translatable((String)"jurassicsaga.fence.already_connected").withStyle(ChatFormatting.GOLD);
                    ClientboundSetActionBarTextPacket actionBarPacket = new ClientboundSetActionBarTextPacket((Component)textComponent);
                    serverPlayer.connection.send((Packet)actionBarPacket);
                }
                return InteractionResult.FAIL;
            }
        }
        return super.useOn(context);
    }

    private void tryCreateLinkBetween(UseOnContext context, BlockPos pos1, double distance, BlockPos pos2) {
        Level level = context.getLevel();
        if (pos1.distToCenterSqr((Position)pos2.getCenter()) <= distance) {
            BlockState fence1 = level.getBlockState(pos1);
            if (!fence1.is((Block)JSV2Blocks.POLE.get())) {
                return;
            }
            BlockState fence2 = level.getBlockState(pos2);
            if (!fence2.is((Block)JSV2Blocks.POLE.get())) {
                return;
            }
            fence1.setValue((Property)PoleBlock.CONNECTED, (Comparable)Boolean.valueOf(true));
            fence2.setValue((Property)PoleBlock.CONNECTED, (Comparable)Boolean.valueOf(true));
            this.place(level, fence1, fence2, pos1, pos2, distance, context);
        }
    }

    private void place(Level level, BlockState fence1, BlockState fence2, BlockPos pos1, BlockPos pos2, double distance, UseOnContext context) {
        fence1 = (BlockState)fence1.setValue((Property)PoleBlock.CONNECTED, (Comparable)Boolean.valueOf(true));
        fence2 = (BlockState)fence2.setValue((Property)PoleBlock.CONNECTED, (Comparable)Boolean.valueOf(true));
        Vec3 center1 = pos1.getCenter();
        Vec3 center2 = pos2.getCenter();
        Vec3 delta = center2.subtract(center1);
        Vec3 dir = delta.normalize();
        double fullLength = delta.length();
        double inset = 0.1875;
        Vec3 start = center1.add(dir.scale(inset));
        Vec3 end = center2.add(dir.scale(-inset));
        Vec3 mid = center1.add(dir.scale(fullLength / 2.0));
        float yaw = (float)(Math.toDegrees(Math.atan2(delta.z, delta.x)) + 90.0);
        float pitch = (float)Math.toDegrees(Math.atan2(delta.y, Math.sqrt(delta.x * delta.x + delta.z * delta.z)));
        double yOffset = -0.45;
        for (int i = 0; i < 2; ++i) {
            Vec3 startY = start.add(0.0, yOffset, 0.0);
            Vec3 endY = end.add(0.0, yOffset, 0.0);
            Vec3 midY = startY.add(endY).scale(0.5);
            FenceCable cable = new FenceCable(JSV2Entities.FENCE_CABLE.get(), level);
            cable.teleportTo(midY.x, midY.y, midY.z);
            cable.absRotateTo(yaw, pitch);
            cable.setLink1(pos1);
            cable.setLink2(pos2);
            cable.setDataLength((float)(endY.distanceTo(startY) + inset * 2.0));
            double step = 0.1;
            double length = startY.distanceTo(endY);
            int steps = Mth.floor((double)(length / step));
            for (int s = 0; s <= steps; ++s) {
                Vec3 point = startY.add(dir.scale((double)s * step));
                BlockPos placePos = BlockPos.containing((double)point.x, (double)point.y, (double)point.z);
                if (level.isClientSide() || !level.isEmptyBlock(placePos)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                BlockState state = ((Block)JSV2Blocks.WIRE_BLOCK.get()).defaultBlockState();
                state = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)WireBlock.NORTH, (Comparable)Boolean.valueOf(WireItem.connectsTo(level, placePos.north())))).setValue((Property)WireBlock.SOUTH, (Comparable)Boolean.valueOf(WireItem.connectsTo(level, placePos.south())))).setValue((Property)WireBlock.WEST, (Comparable)Boolean.valueOf(WireItem.connectsTo(level, placePos.west())))).setValue((Property)WireBlock.EAST, (Comparable)Boolean.valueOf(WireItem.connectsTo(level, placePos.east())));
                level.setBlock(placePos, state, 3);
                serverLevel.getChunkSource().blockChanged(placePos);
                for (Direction d : Direction.Plane.HORIZONTAL) {
                    BlockPos nPos = placePos.relative(d);
                    BlockState nState = level.getBlockState(nPos);
                    if (!(nState.getBlock() instanceof WireBlock)) continue;
                    BlockState newNState = (BlockState)((BlockState)((BlockState)((BlockState)nState.setValue((Property)WireBlock.NORTH, (Comparable)Boolean.valueOf(WireItem.connectsTo(level, nPos.north())))).setValue((Property)WireBlock.SOUTH, (Comparable)Boolean.valueOf(WireItem.connectsTo(level, nPos.south())))).setValue((Property)WireBlock.WEST, (Comparable)Boolean.valueOf(WireItem.connectsTo(level, nPos.west())))).setValue((Property)WireBlock.EAST, (Comparable)Boolean.valueOf(WireItem.connectsTo(level, nPos.east())));
                    level.setBlock(nPos, newNState, 3);
                }
            }
            level.addFreshEntity((Entity)cable);
            yOffset += 0.5;
        }
    }

    private static boolean connectsTo(Level level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() instanceof WireBlock || level.getBlockState(pos).getBlock() instanceof PoleBlock;
    }
}

