/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.world.feature;

import java.util.List;
import java.util.OptionalInt;
import jp.jurassicsaga.server.base.world.feature.JSFeatures;
import jp.jurassicsaga.server.v1.world.feature.features.JSSimpleBlockFeature;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class JSV2ConfiguredFeatures {
    private static BootstrapContext<ConfiguredFeature<?, ?>> currentContext;
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHALE;
    public static final ResourceKey<ConfiguredFeature<?, ?>> RHYOLITE;
    public static final ResourceKey<ConfiguredFeature<?, ?>> DOG_WOOD;
    public static final ResourceKey<ConfiguredFeature<?, ?>> FANCY_DOG_WOOD;

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        currentContext = context;
        TagMatchTest stoneReplaceable = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> shaleTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((Block)JSV2Blocks.SHALE.BLOCK.get()).defaultBlockState()));
        context.register(SHALE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(shaleTargets, 33)));
        List<OreConfiguration.TargetBlockState> rhyoliteTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((Block)JSV2Blocks.RHYOLITE.BLOCK.get()).defaultBlockState()));
        context.register(RHYOLITE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(rhyoliteTargets, 33)));
        JSV2ConfiguredFeatures.register(DOG_WOOD, Feature.TREE, JSV2ConfiguredFeatures.createDogWood().build());
        JSV2ConfiguredFeatures.register(FANCY_DOG_WOOD, Feature.TREE, JSV2ConfiguredFeatures.createFancyDogWood().build());
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block logBlock, Block leavesBlock, int baseHeight, int heightRandA, int heightRandB, int radius) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)logBlock), (TrunkPlacer)new StraightTrunkPlacer(baseHeight, heightRandA, heightRandB), (BlockStateProvider)BlockStateProvider.simple((Block)leavesBlock), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)radius), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createDogWood() {
        return JSV2ConfiguredFeatures.createStraightBlobTree((Block)JSV2Blocks.DOG_WOOD.LOG.get(), (Block)JSV2Blocks.DOG_WOOD.LEAVES.get(), 4, 2, 0, 2).ignoreVines();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyDogWood() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)JSV2Blocks.DOG_WOOD.LOG.get())), (TrunkPlacer)new FancyTrunkPlacer(3, 5, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)JSV2Blocks.DOG_WOOD.LEAVES.get())), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).ignoreVines();
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        currentContext.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    private static void registerSimplePlant(ResourceKey<ConfiguredFeature<?, ?>> featureResourceKey, int tries, int xzSpread, int ySpread, Block block) {
        JSSimpleBlockFeature feature = (JSSimpleBlockFeature)((Object)JSFeatures.SIMPLE_BLOCK.get());
        JSV2ConfiguredFeatures.register(featureResourceKey, Feature.RANDOM_PATCH, new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)block)), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.ONLY_IN_AIR_PREDICATE}))));
    }

    static {
        SHALE = JSV2ConfiguredFeatures.registerKey("shale");
        RHYOLITE = JSV2ConfiguredFeatures.registerKey("rhyolite");
        DOG_WOOD = JSV2ConfiguredFeatures.registerKey("dog_wood");
        FANCY_DOG_WOOD = JSV2ConfiguredFeatures.registerKey("fancy_dog_wood");
    }
}

