/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.world.feature;

import java.util.List;
import jp.jurassicsaga.server.v2.world.feature.JSV2ConfiguredFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class JSV2PlacedFeatures {
    private static BootstrapContext<PlacedFeature> currentContext;
    private static HolderGetter<ConfiguredFeature<?, ?>> cfg;
    public static final ResourceKey<PlacedFeature> SHALE;
    public static final ResourceKey<PlacedFeature> RHYOLITE;

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        currentContext = context;
        cfg = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference shale = context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(JSV2ConfiguredFeatures.SHALE);
        Holder.Reference rhyolite = context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(JSV2ConfiguredFeatures.RHYOLITE);
        context.register(SHALE, (Object)new PlacedFeature((Holder)shale, List.of(CountPlacement.of((int)10), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)128)), BiomeFilter.biome())));
        context.register(RHYOLITE, (Object)new PlacedFeature((Holder)rhyolite, List.of(CountPlacement.of((int)10), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)128)), BiomeFilter.biome())));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)name));
    }

    private static void register(ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        currentContext.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void registerPlant(ResourceKey<PlacedFeature> resourceKey, ResourceKey<ConfiguredFeature<?, ?>> resourceKey2, int chance) {
        JSV2PlacedFeatures.register(resourceKey, cfg.getOrThrow(resourceKey2), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)chance), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    private static void register(ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        JSV2PlacedFeatures.register(key, configuration, List.of(modifiers));
    }

    static {
        SHALE = JSV2PlacedFeatures.createKey("shale");
        RHYOLITE = JSV2PlacedFeatures.createKey("rhyolite");
    }
}

