/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import java.util.HashMap;
import jp.jurassicsaga.JSConstants;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSModuleHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSLookControl;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1330;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.other.TravelersBodyRotationControl;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.packet.obj.TravelersShakeCamera;
import travelers.util.helper.TravelersPacketDistributor;

public class JSAnimalBase
extends JSEntityDataHolder {
    public boolean isLoaded = false;
    private JSModuleHolder modules;
    private boolean isStaticCreature;
    private boolean isFrozenInPlace;
    private boolean firstTick = true;
    private HashMap<class_6880<class_1320>, Double> statMap = new HashMap();
    private class_1309 fleeTarget;
    private final class_1277 container = new class_1277(1);
    private float previousYaw = 0.0f;
    private double curSpeed = 0.0;
    private int corpseDropCount = 0;
    public int curInjuredTicks;
    public int curAttackTicks;
    public int curEatTicks;
    public int curDrinkTicks;

    public JSAnimalBase(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.moveController = new TravelersMoveControl((SmartAnimalBase)this, this.getAnimal());
        this.field_6206 = new JSLookControl(this);
        this.field_5985 = true;
        this.createModuleHolder();
        if (this.modules != null) {
            this.modules.init();
        }
        if (TravelersMain.isDebugging()) {
            JSConstants.LOG.warn("Added {} to the world.", (Object)this.getAnimal().getAnimalAttributes().getAnimalName());
        }
    }

    @NotNull
    protected class_1330 method_5963() {
        return new TravelersBodyRotationControl((SmartAnimalBase)this);
    }

    public boolean method_6109() {
        if (this.getModules() == null) {
            return true;
        }
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
    }

    public boolean isStalking() {
        return !this.isDead() && (Boolean)this.field_6011.method_12789(stalking) != false;
    }

    public void onGrowthStageChange(AnimalGrowthStage newStage) {
    }

    public void method_6005(double strength, double x, double z) {
        if (this.isDead()) {
            return;
        }
        super.method_6005(strength, x, z);
    }

    public boolean method_6101() {
        return false;
    }

    public boolean method_5747(float fallDistance, float multiplier, @NotNull class_1282 source) {
        if ((double)fallDistance > this.jumpHeight() * 2.0) {
            return super.method_5747(fallDistance, multiplier, source);
        }
        return false;
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        if ((double)fallDistance > this.jumpHeight() * 2.0) {
            return super.method_23329(fallDistance, damageMultiplier);
        }
        return 0;
    }

    public double method_23320() {
        return super.method_23320();
    }

    protected void createModuleHolder() {
        this.modules = new JSModuleHolder(this);
    }

    public JSAnimal<?> getAnimal() {
        return (JSAnimal)super.getAnimal();
    }

    public float getRenderScale() {
        return this.getModules().getGrowthStageModule().getSize();
    }

    @NotNull
    protected class_238 method_33332() {
        TravelersAnimal animal1 = this.getAnimal();
        if (animal1 == null || !this.method_37908().method_8477(this.method_24515())) {
            return this.method_55694(this.method_18376()).method_30757(this.method_19538());
        }
        return this.getModules().getGrowthStageModule().makeBoundingBox((JSAnimal<?>)animal1);
    }

    @NotNull
    protected class_4048 method_55694(@NotNull class_4050 pose) {
        if (this.getModules() != null && this.getModules().getGrowthStageModule().getDimensions() != null) {
            return this.getModules().getGrowthStageModule().getDimensions();
        }
        return super.method_55694(pose);
    }

    @Nullable
    public class_1799 method_31480() {
        class_1799 stack = ((class_1792)this.getAnimal().getItems().getSpawnEgg().get()).method_7854();
        JSGeneUtil.writeToStack(stack, this.getModules().getGeneticModule().getGeneData());
        return stack;
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        IJSLeapingEntity leapingEntity;
        Object object;
        if (source == this.method_48923().method_48822() && (object = this) instanceof IJSLeapingEntity && (leapingEntity = (IJSLeapingEntity)object).isLeaping()) {
            return false;
        }
        this.curInjuredTicks = 4;
        boolean wasHurt = super.method_5643(source, amount);
        if (amount > 0.0f) {
            if (source.method_49708(class_8111.field_42341)) {
                return false;
            }
            this.handleCorpseHit(source, wasHurt, amount);
            this.getModules().getMetabolismModule().interrupt(10);
        }
        for (JSGene jsGene : this.getModules().getGeneticModule().getGeneData().geneDataHolder.getGENE_SET()) {
            jsGene.onHitBy(this, this.method_6065(), source, amount);
        }
        return wasHurt;
    }

    private void handleCorpseHit(@NotNull class_1282 source, boolean wasHurt, float amount) {
        if (!this.isDead()) {
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        TravelersAnimalAttributes animalAttributes = this.getAnimal().getAnimalAttributes();
        if ((source.method_5526() instanceof class_3222 || source.method_5529() instanceof class_3222 || source.method_49708(class_8111.field_42320)) && wasHurt && animalAttributes.getItemProperties().isHasDrops() && animalAttributes.getMiscProperties().isShouldCorpseDropItems()) {
            float missing = (float)(this.getScaledMaxHealth() - (double)this.method_6032());
            int dropTimes = Math.max(!this.method_6109() ? animalAttributes.getMiscProperties().getCorpseDropTimes() : 1, 1);
            double req = this.getScaledMaxHealth() / (double)dropTimes;
            int expectedDrops = (int)((double)missing / req);
            while (this.corpseDropCount < expectedDrops) {
                if (animalAttributes.getItemProperties().isHasMeat()) {
                    int amountToDrop = Math.abs(this.field_5974.method_43048(((Integer)animalAttributes.getMiscProperties().getCorpseMeatDropRange().getB()).intValue()) + (Integer)animalAttributes.getMiscProperties().getCorpseMeatDropRange().getA());
                    this.method_5775(new class_1799((class_1935)this.getAnimal().getItems().getRawMeat().get(), amountToDrop));
                }
                if (animalAttributes.getMiscProperties().isExtinct()) {
                    int bonesToDrop = Math.abs(this.field_5974.method_43048(((Integer)animalAttributes.getMiscProperties().getCorpseBoneDropRange().getB()).intValue()) + (Integer)animalAttributes.getMiscProperties().getCorpseBoneDropRange().getA());
                    this.method_5775(new class_1799((class_1935)this.getAnimal().getItems().getFossil_remains().get(), bonesToDrop));
                }
                ++this.corpseDropCount;
            }
        }
    }

    public int getMaxCorpseFoodPoints() {
        return (int)JSUtils.toTickMinutes((float)this.getScaledMaxHealth() * 2.0f);
    }

    public int getCorpseFoodPoints() {
        return (int)JSUtils.toTickMinutes(this.method_6032() * 2.0f);
    }

    protected void method_6108() {
        if (this.isDead() || this.shouldDieInstantly()) {
            if (this.shouldDieInstantly() && this.getAnimal().getAnimalAttributes().getItemProperties().isHasDrops()) {
                if (this.getAnimal().getAnimalAttributes().getItemProperties().isHasMeat() && this.field_5974.method_43057() < 0.6f) {
                    this.method_5775(new class_1799((class_1935)this.getAnimal().getItems().getRawMeat().get(), this.field_5974.method_43048(4) + 1));
                }
                if (this.getAnimal().getAnimalAttributes().getMiscProperties().isExtinct() && this.field_5974.method_43057() < 0.6f) {
                    this.method_5775(new class_1799((class_1935)this.getAnimal().getItems().getFossil_remains().get(), this.field_5974.method_43048(4) + 1));
                }
            }
            if (!this.method_37908().method_8608() && !this.method_31481()) {
                this.method_37908().method_8421((class_1297)this, (byte)60);
                this.method_5650(class_1297.class_5529.field_26998);
            }
            return;
        }
        this.setDead(true);
        this.method_6033((float)this.getScaledMaxHealth());
        this.method_55695();
        this.field_6189.method_6340();
        this.navigationController.stop();
        this.field_6201.method_35115().clear();
    }

    public boolean shouldDieInstantly() {
        return false;
    }

    protected float method_6107() {
        return this.isDead() || this.method_6113() ? 0.0f : 0.1f;
    }

    public void method_5697(class_1297 entity) {
        double otherPoints;
        double hitboxPoints = this.method_17681() + this.method_17682();
        if (hitboxPoints - (otherPoints = (double)(entity.method_17682() + entity.method_17681())) < -1.0) {
            return;
        }
        super.method_5697(entity);
    }

    public void setExtraStat(class_6880<class_1320> stat, double i) {
        if (this.statMap == null) {
            this.statMap = new HashMap();
        }
        if (this.statMap.containsKey(stat)) {
            this.statMap.put(stat, this.statMap.get(stat) + i);
        } else {
            this.statMap.put(stat, i);
        }
    }

    public void removeFromStat(class_6880<class_1320> stat, double i) {
        if (this.statMap == null) {
            this.statMap = new HashMap();
        }
        if (this.statMap.containsKey(stat)) {
            double count = Math.max(0.0, this.statMap.get(stat) - i);
            if (count > 0.0) {
                this.statMap.put(stat, count);
            } else {
                this.statMap.remove(stat);
            }
        }
    }

    public double method_45325(class_6880<class_1320> attribute) {
        double stats;
        double d = stats = this.statMap != null ? this.statMap.getOrDefault(attribute, 0.0) : 0.0;
        if (attribute.method_55838(class_5134.field_23716)) {
            return this.getScaledMaxHealth() + stats;
        }
        if (attribute.method_55838(class_5134.field_23722)) {
            double val = super.method_45325(attribute);
            float scale = this.getModules().getGrowthStageModule().getPercentage();
            return class_3532.method_16436((double)scale, (double)(val / 4.0), (double)val) + stats;
        }
        return super.method_45325(attribute) + stats;
    }

    private double getScaledMaxHealth() {
        if (this.getAnimal() == null) {
            return super.method_45325(class_5134.field_23716);
        }
        double maxHealth = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMaxHealth();
        float scale = this.getModules().getGrowthStageModule().getPercentage();
        if (scale == 0.0f || scale == 1.0f) {
            return maxHealth;
        }
        return class_3532.method_16436((double)scale, (double)Math.min(5.0, maxHealth / 15.0), (double)maxHealth);
    }

    protected float method_6106() {
        TravelersPath path;
        if (this.method_5799()) {
            return this.method_56994(1.0f);
        }
        if (this.jumpHeight() > 1.0 && (path = this.getNavigationController().getPath()) != null && !path.isDone() && path.getNextNodeIndex() < path.getNodeCount()) {
            TravelersNode nextNode = path.getNextNode();
            if ((double)nextNode.y > this.method_23318()) {
                double diff = (double)nextNode.y - this.method_23318();
                return this.method_56994((float)((double)1.2f + diff / 4.0));
            }
        }
        return this.method_5799() ? this.method_56994(1.0f) : this.method_56994(2.35f);
    }

    public void method_6043() {
        float f = this.method_6106();
        if (!(f <= 1.0E-5f)) {
            class_243 vec3 = this.method_18798();
            this.method_18800(vec3.field_1352, f, vec3.field_1350);
            if (this.method_5624()) {
                float f1 = this.method_36454() * ((float)Math.PI / 180);
                this.method_45319(new class_243((double)(-class_3532.method_15374((float)f1)) * 0.2, 0.0, (double)class_3532.method_15362((float)f1) * 0.2));
            }
            this.field_6007 = true;
            JSAnimalBase jSAnimalBase = this;
            if (jSAnimalBase instanceof IJSLeapingEntity) {
                IJSLeapingEntity leapingEntity = (IJSLeapingEntity)((Object)jSAnimalBase);
                leapingEntity.onLeap();
            }
        }
    }

    public void method_5773() {
        if (this.getAnimal() != null && this.firstTick) {
            this.method_5857(this.method_33332());
            this.firstTick = false;
        } else if (this.isStaticCreature) {
            return;
        }
        super.method_5773();
        if (this.method_37908().field_9236) {
            this.modules.clientTick();
        }
        if (this.curInjuredTicks > 0) {
            --this.curInjuredTicks;
        }
        if (this.curAttackTicks > 0) {
            --this.curAttackTicks;
        }
        if (this.curEatTicks > 0) {
            --this.curEatTicks;
        }
        this.modules.tick();
        if (((Boolean)this.field_6011.method_12789(refreshData)).booleanValue()) {
            this.field_6011.method_12778(refreshData, (Object)false);
        }
    }

    public void method_6007() {
        class_1309 target;
        if (this.isStaticCreature && !this.firstTick) {
            return;
        }
        super.method_6007();
        if (this.method_5968() != null && !(target = this.method_5968()).method_5805()) {
            this.method_5980(null);
        }
        this.modules.aiStep();
    }

    protected void method_5958() {
        class_243 nextPos;
        if (this.isStaticCreature) {
            return;
        }
        this.getAnimal().animateServer(this, this.moveAnalysis, null);
        super.method_5958();
        TravelersPath path = this.getNavigationController().getPath();
        if (path != null && !path.isDone() && (nextPos = path.getNextNode().asVec3()) != null) {
            nextPos = nextPos.method_1031(0.0, (double)this.method_5751(), 0.0);
            this.method_5988().method_19615(nextPos);
        }
        if (this.shouldSleep() && !this.method_6113()) {
            this.setSleeping(true);
        } else if (this.method_6113() && !this.shouldSleep()) {
            this.setSleeping(false);
        }
        this.modules.serverAiStep();
    }

    public boolean method_31746() {
        return !this.isStaticCreature;
    }

    @NotNull
    protected class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (this.canEatFromPlayer(player, hand)) {
            this.onEatFromPlayer(player, hand, itemstack);
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5931() {
        return this.method_17682() < 1.0f;
    }

    protected boolean canEatFromPlayer(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        return this.modules.getMetabolismModule().getDiet() != null && this.modules.getMetabolismModule().getDiet().canEatItem(itemstack);
    }

    protected void onEatFromPlayer(class_1657 player, class_1268 hand, class_1799 stack) {
    }

    @Override
    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        this.modules.saveNbt(compound);
    }

    @Override
    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.modules.loadNbt(compound);
    }

    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
        if (this.isStaticCreature) {
            return;
        }
        super.method_5712(pos, state);
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        this.modules.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.method_5857(this.method_33332());
        return super.method_5943(level, difficulty, spawnType, spawnGroupData);
    }

    protected boolean canRunInWater() {
        return false;
    }

    protected TravelersPathNavigation createNavigationController(class_1937 level) {
        return new JSGroundNavigation(this, level);
    }

    public float getHeadRotationSpeed() {
        return 0.5f;
    }

    public boolean isMoving() {
        return this.moveAnalysis.isMoving();
    }

    public boolean isDead() {
        return (Boolean)this.field_6011.method_12789(dead);
    }

    public boolean shouldSleep() {
        if (this.isDead()) {
            return false;
        }
        if (this.getNavigationController().isInProgress()) {
            return false;
        }
        if (this.modules.getMetabolismModule().isInterrupted()) {
            return false;
        }
        if (!this.method_24828()) {
            return false;
        }
        ActiveTime sleeptime = this.getAnimal().getAnimalAttributes().getMetabolismProperties().getActiveTime();
        return !sleeptime.isActiveNow(this.method_37908().method_8532());
    }

    public double getTrackingRange() {
        return this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getTrackingRange();
    }

    public float getAttackReach() {
        return this.method_17681() * this.method_17681() + this.method_17681();
    }

    public void attack(class_1309 target) {
        this.method_6121((class_1297)target);
        this.curAttackTicks = 4;
    }

    private int attackLength() {
        return 20;
    }

    protected void method_59928() {
        class_3414 sound = this.getAttackSound();
        if (sound != null) {
            this.method_43077(sound);
        }
    }

    @Nullable
    protected class_3414 getAttackSound() {
        return null;
    }

    @Nullable
    protected class_3414 getCallSound() {
        return null;
    }

    public void callSounds() {
        class_3414 sound = this.getCallSound();
        if (sound != null) {
            this.method_43077(sound);
        }
    }

    public float method_6029() {
        double speed = 0.0;
        double baseSpeed = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed();
        float scale = this.method_55693();
        if (scale != 1.0f) {
            baseSpeed /= (double)scale;
        }
        float currentYaw = this.method_36454();
        float turningAmount = Math.abs(currentYaw - this.previousYaw);
        turningAmount = (turningAmount + 180.0f) % 360.0f - 180.0f;
        if ((turningAmount = Math.abs(turningAmount)) > 5.0f) {
            float turnSlowdown = Math.min(1.0f, turningAmount / 90.0f);
            baseSpeed *= (double)(1.0f - 0.3f * turnSlowdown);
        }
        if (this.curSpeed == 0.0) {
            this.curSpeed = baseSpeed;
        }
        float acceleration = 0.025f * this.getAnimal().getAnimalAttributes().getMetabolismProperties().getAccelerationSpeedMultiplier();
        speed = this.isStalking() ? class_3532.method_16436((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * (double)this.getAnimal().getAnimalAttributes().getMetabolismProperties().getStalkingSpeedMultiplier())) : (this.isRunning() ? class_3532.method_16436((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getRunningSpeedMultiplier())) : (this.method_5799() ? class_3532.method_16436((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getSwimmingSpeedMultiplier())) : (this.getNavigationController().isInProgress() ? class_3532.method_16436((double)acceleration, (double)this.curSpeed, (double)baseSpeed) : baseSpeed)));
        this.previousYaw = currentYaw;
        this.curSpeed = speed;
        return (float)speed;
    }

    public void freezeAnimator() {
        this.freezeAnimator = true;
    }

    public void shakeCamera(float multiplier, boolean groundCheck) {
        if (this.isStaticCreature()) {
            return;
        }
        if (!this.method_37908().field_9236 && this.canShake()) {
            TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)this, (class_8710)new TravelersShakeCamera(groundCheck, this.shakeAmount() * multiplier, (int)((float)this.shakeLength() * multiplier), this.shakeDistance(), this.method_19538().method_46409()));
        }
    }

    public boolean canShake() {
        return this.shakeAmount() > 0.0f && (float)this.shakeLength() > 0.0f && this.shakeDistance() > 0.0f;
    }

    public int shakeLength() {
        return 0;
    }

    public float shakeAmount() {
        return 0.0f;
    }

    public float shakeDistance() {
        return 0.0f;
    }

    public boolean hasSolidBelow() {
        class_238 aabb = this.method_5829();
        return this.hasCollisions(aabb.method_1009(0.0, 0.5, 0.0));
    }

    protected boolean checkForCollide() {
        class_238 aabb = this.method_5829();
        return this.hasCollisions(aabb.method_1009(0.5, 0.0, 0.5));
    }

    protected boolean hasCollisions(class_238 boundingBox) {
        return !this.noBlockCollision((class_1297)this, boundingBox);
    }

    protected boolean noBlockCollision(@Nullable class_1297 entity, class_238 boundingBox) {
        for (class_2338 pos : class_2338.method_10097((class_2338)class_2338.method_49637((double)boundingBox.field_1323, (double)boundingBox.field_1322, (double)boundingBox.field_1321), (class_2338)class_2338.method_49637((double)(boundingBox.field_1320 - 1.0E-7), (double)(boundingBox.field_1325 - 1.0E-7), (double)(boundingBox.field_1324 - 1.0E-7)))) {
            class_265 shape;
            class_2680 state = this.method_37908().method_8320(pos);
            if (state.method_26222((class_1922)this.method_37908(), pos).method_1110() || (shape = state.method_26194((class_1922)this.method_37908(), pos, class_3726.method_16195((class_1297)entity))).method_1110() || !shape.method_1107().method_994(boundingBox)) continue;
            return false;
        }
        return true;
    }

    public JSModuleHolder getModules() {
        return this.modules;
    }

    public boolean isStaticCreature() {
        return this.isStaticCreature;
    }

    public void setStaticCreature(boolean isStaticCreature) {
        this.isStaticCreature = isStaticCreature;
    }

    public void setFrozenInPlace(boolean isFrozenInPlace) {
        this.isFrozenInPlace = isFrozenInPlace;
    }

    public boolean isFrozenInPlace() {
        return this.isFrozenInPlace;
    }

    public class_1309 getFleeTarget() {
        return this.fleeTarget;
    }

    public void setFleeTarget(class_1309 fleeTarget) {
        this.fleeTarget = fleeTarget;
    }

    public class_1277 getContainer() {
        return this.container;
    }
}

