/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.class_1266;
import net.minecraft.class_1315;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGeneticModule
extends JSAnimalModuleBase {
    private JSGeneData geneData;

    public JSGeneticModule(JSAnimalBase owner) {
        super(owner);
    }

    @Override
    public void tick() {
        if (this.shouldRefresh()) {
            this.geneData = null;
        }
    }

    @Override
    public void saveNbt(class_2487 nbt) {
        class_2487 tag = new class_2487();
        this.getGeneData().saveToNbt(tag);
        nbt.method_10566("js.genetics.data", (class_2520)tag);
        nbt.method_10582("js.genetics.variant", (String)this.owner.method_5841().method_12789(JSEntityDataHolder.textureVariant));
        nbt.method_10556("js.genetics.male", this.isMale());
    }

    public JSGeneData getGeneData() {
        if (this.geneData != null) {
            return this.geneData;
        }
        class_2487 tag = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.gene_data);
        JSGeneData data = new JSGeneData();
        data.loadFromNbt(tag);
        this.geneData = data;
        return data;
    }

    @Override
    public void loadNbt(class_2487 nbt) {
        this.getGeneData().loadFromNbt(nbt.method_10562("js.genetics.data"));
        this.setMale(nbt.method_10577("js.genetics.male"));
        this.refreshGenes();
    }

    private void refreshGenes() {
        for (JSGene jsGene : this.getGeneData().geneDataHolder.getGENE_SET()) {
            jsGene.applyTo(this.owner);
        }
    }

    public void setGeneData(JSGeneData data) {
        this.writeDataToEntity(data);
        this.refreshGenes();
    }

    public void writeDataToEntity(JSGeneData geneData) {
        class_2487 tag = new class_2487();
        geneData.saveToNbt(tag);
        this.owner.method_5841().method_12778(JSEntityDataHolder.gene_data, (Object)tag);
        this.refresh();
        this.geneData = null;
    }

    @Override
    public void finalizeSpawn(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        this.setMale(level.method_8409().method_43056());
        JSGeneData geneData = this.getGeneData();
        geneData.setGeneSeed(level.method_8409().method_43054());
        geneData.setSizeDimorphism((float)(level.method_8409().method_43048((int)this.owner.getAnimal().getAnimalAttributes().getEntityBaseProperties().getSizeDimorphism()) + 1) / 750.0f);
        this.writeDataToEntity(geneData);
        this.refresh();
    }

    @Override
    public void init() {
    }

    public void hatch() {
        for (JSGene gene : this.getGeneData().geneDataHolder.getGENE_SET()) {
            gene.onHatch(this.owner);
        }
    }

    public void setMale(boolean male) {
        this.owner.method_5841().method_12778(JSEntityDataHolder.male, (Object)male);
    }

    public boolean isMale() {
        return (Boolean)this.owner.method_5841().method_12789(JSEntityDataHolder.male);
    }
}

