/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.obj.GrowthStageData;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import net.minecraft.class_1266;
import net.minecraft.class_1315;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.attributes.EntityBaseProperties;

public class JSGrowthStageModule
extends JSAnimalModuleBase {
    private final JSAnimal<?> animal;
    private class_4048 dimensions = null;

    protected JSGrowthStageModule(JSAnimalBase owner) {
        super(owner);
        this.animal = owner.getAnimal();
    }

    @Override
    public void serverAiStep() {
        if (this.owner.isDead()) {
            return;
        }
        if (this.getGrowthProgress() != this.getMaxGrowth() && this.owner.getAnimal().getAnimalAttributes().getGeneticProperties().getBabyData() != null) {
            int growthProgress = this.getGrowthProgress();
            int growthRate = this.getGrowthMultiplier() * this.getGrowthMultiplier();
            this.setGrowthProgress(Math.min(this.getMaxGrowth(), growthProgress + growthRate));
            if (this.getGrowthStage() != AnimalGrowthStage.ADULT) {
                GrowthStageData stage = this.owner.getAnimal().getAnimalAttributes().getGeneticProperties().getBabyData();
                int nextValue = this.getGrowthMultiplier() * this.getGrowthMultiplier();
                int maxGrowth = this.getMaxGrowth();
                if (growthProgress + nextValue > (stage.getMaxGrowth() != -1 ? stage.getMaxGrowth() : maxGrowth)) {
                    this.setGrowthStage(AnimalGrowthStage.ADULT);
                } else {
                    this.setGrowthProgress(Math.min(maxGrowth, growthProgress + growthRate));
                }
                this.owner.method_6025(0.01f);
            }
        } else if (this.getGrowthStage() != AnimalGrowthStage.ADULT) {
            this.setGrowthStage(AnimalGrowthStage.ADULT);
        }
    }

    public int getGrowthMultiplier() {
        return 2;
    }

    @Override
    public void saveNbt(class_2487 nbt) {
        nbt.method_10566("js.growthstage", (class_2520)this.toTag());
    }

    private class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("js.growthstage.stage", this.getGrowthStage().getId());
        tag.method_10569("js.growthstage.progress", this.getGrowthProgress());
        tag.method_10569("js.growthstage.growthspeed", this.getGrowthSpeed());
        return tag;
    }

    @Override
    public void loadNbt(class_2487 nbt) {
        class_2487 tag = nbt.method_10562("js.growthstage");
        this.setGrowthStage(AnimalGrowthStage.getById(tag.method_10550("js.growthstage.stage")));
        this.setGrowthProgress(tag.method_10550("js.growthstage.progress"));
        this.setGrowthSpeed(tag.method_10550("js.growthstage.speed"));
        this.refreshData(tag);
    }

    @Override
    public void init() {
    }

    @Override
    public void finalizeSpawn(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        if (spawnType == class_3730.field_16459 || spawnType == class_3730.field_16471 || spawnType == class_3730.field_16472 || spawnType == class_3730.field_16469 || spawnType == class_3730.field_16462) {
            this.setGrowthProgress(this.getMaxGrowth());
        }
        if (spawnType == class_3730.field_16465) {
            this.owner.method_5971();
        }
        this.refreshData();
    }

    private void refreshData() {
        this.refreshData(this.toTag());
    }

    private void refreshData(class_2487 tag) {
        this.owner.method_5841().method_12778(JSEntityDataHolder.growth_data, (Object)tag);
    }

    @NotNull
    public class_238 makeBoundingBox(JSAnimal<?> animal1) {
        boolean needsUpdate;
        float y;
        float xz;
        TravelersAnimalAttributes attributes = animal1.getAnimalAttributes();
        float eyeHeightRatio = (float)attributes.getEntityAttributeProperties().getEyeHeight();
        GrowthStageData babyData = attributes.getGeneticProperties().getBabyData();
        float scale = 1.0f;
        if (this.getGrowthProgress() != this.getMaxGrowth() && babyData != null && babyData.getSizeXZ() * scale > 0.0f && babyData.getSizeY() * scale > 0.0f) {
            float curXZ = babyData.getSizeXZ() * scale;
            float curY = babyData.getSizeY() * scale;
            float nextXZ = (float)(this.owner.getModules().getGeneticModule().isMale() && attributes.getEntityBaseProperties().getDimensionsMale() != null ? attributes.getEntityBaseProperties().getDimensionsMale()[0] : attributes.getEntityAttributeProperties().getDimensions()[0]);
            float nextY = (float)(this.owner.getModules().getGeneticModule().isMale() && attributes.getEntityBaseProperties().getDimensionsMale() != null ? attributes.getEntityBaseProperties().getDimensionsMale()[1] : attributes.getEntityAttributeProperties().getDimensions()[1]);
            double progress = this.getPercentage();
            xz = (float)class_3532.method_16436((double)progress, (double)curXZ, (double)(nextXZ * scale));
            y = (float)class_3532.method_16436((double)progress, (double)curY, (double)(nextY * scale));
        } else if (this.owner.getModules().getGeneticModule().isMale() && attributes.getEntityBaseProperties().getDimensionsMale() != null) {
            xz = (float)(attributes.getEntityBaseProperties().getDimensionsMale()[0] * (double)scale);
            y = (float)(attributes.getEntityBaseProperties().getDimensionsMale()[1] * (double)scale);
        } else {
            xz = (float)(attributes.getEntityAttributeProperties().getDimensions()[0] * (double)scale);
            y = (float)(attributes.getEntityAttributeProperties().getDimensions()[1] * (double)scale);
        }
        boolean bl = needsUpdate = this.dimensions == null || this.dimensions.comp_2185() != xz || this.dimensions.comp_2186() != y;
        if (needsUpdate) {
            this.dimensions = class_4048.method_18384((float)xz, (float)y);
            if (eyeHeightRatio > 0.0f) {
                this.dimensions = this.dimensions.method_55685(y * eyeHeightRatio);
            }
            this.owner.method_18382();
        }
        return this.dimensions.method_30757(this.owner.method_19538());
    }

    public float getSize() {
        GrowthStageData data;
        TravelersAnimalAttributes props = this.animal.getAnimalAttributes();
        JSGeneticProperties genetics = props.getGeneticProperties();
        EntityBaseProperties generic = props.getEntityBaseProperties();
        if (this.getGrowthProgress() != this.getMaxGrowth() && (data = genetics.getBabyData()) != null) {
            float scale = data.getScaleMultiplier();
            float nextScale = data.getNextScale() > 0.0f && this.getGrowthStage() != AnimalGrowthStage.ADULT ? data.getNextScale() : ((Boolean)this.owner.method_5841().method_12789(JSEntityDataHolder.male) != false && generic.getRenderScaleMale() != -1.0 ? (float)generic.getRenderScaleMale() : (float)generic.getRenderScale());
            double progress = this.getPercentage();
            double scaleSize = class_3532.method_16436((double)progress, (double)scale, (double)nextScale);
            return (float)((scaleSize + (double)this.owner.getModules().getGeneticModule().getGeneData().getSizeDimorphism()) * 1.0);
        }
        double baseScale = (Boolean)this.owner.method_5841().method_12789(JSEntityDataHolder.male) != false && generic.getRenderScaleMale() != -1.0 ? generic.getRenderScaleMale() : generic.getRenderScale();
        double extraScale = ((Float)this.owner.method_5841().method_12789(JSEntityDataHolder.additionalScale)).floatValue();
        return (float)((baseScale + extraScale + (double)this.owner.getModules().getGeneticModule().getGeneData().getSizeDimorphism()) * 1.0);
    }

    public AnimalGrowthStage getGrowthStage() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.growth_data);
        return AnimalGrowthStage.getById(data.method_10550("js.growthstage.stage"));
    }

    public int getGrowthProgress() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.growth_data);
        return data.method_10550("js.growthstage.progress");
    }

    public float getPercentage() {
        TravelersAnimalAttributes props = this.animal.getAnimalAttributes();
        JSGeneticProperties genetics = props.getGeneticProperties();
        return (float)this.getGrowthProgress() / (float)genetics.getGrowthProgressCap();
    }

    public int getMaxGrowth() {
        return this.animal.getAnimalAttributes().getGeneticProperties().getGrowthProgressCap();
    }

    public int getGrowthSpeed() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.growth_data);
        return data.method_10550("js.growthstage.growthspeed");
    }

    public void setGrowthStage(AnimalGrowthStage animalGrowthStage) {
        if (animalGrowthStage != this.getGrowthStage()) {
            this.owner.onGrowthStageChange(animalGrowthStage);
        }
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.growth_data)).method_10553();
        data.method_10569("js.growthstage.stage", animalGrowthStage.getId());
        this.owner.method_5841().method_12778(JSEntityDataHolder.growth_data, (Object)data);
    }

    public void setGrowthProgress(int progress) {
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.growth_data)).method_10553();
        data.method_10569("js.growthstage.progress", progress);
        this.owner.method_5841().method_12778(JSEntityDataHolder.growth_data, (Object)data);
    }

    public void setGrowthSpeed(int speed) {
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.growth_data)).method_10553();
        data.method_10569("js.growthstage.speed", speed);
        this.owner.method_5841().method_12778(JSEntityDataHolder.growth_data, (Object)data);
    }

    public void setMax() {
        this.setGrowthStage(AnimalGrowthStage.ADULT);
        this.setGrowthProgress(this.getMaxGrowth());
    }

    public class_4048 getDimensions() {
        return this.dimensions;
    }
}

