/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import travelers.server.animal.entity.task.TaskGoal;

public class JSHerdModule
extends JSAnimalModuleBase {
    private JSAnimalBase herdLeader;
    private UUID herdLeaderUUID;
    private final Set<JSAnimalBase> followers = new HashSet<JSAnimalBase>();
    private boolean isMovingToLeader;
    private int checkCooldown;
    private int lookCooldown;
    private int maxDistance;
    private int trueLeaderCooldown = 0;
    private JSAnimalBase cachedTrueLeader;

    public JSHerdModule(JSAnimalBase owner) {
        super(owner);
    }

    public void setHerdLeader(JSAnimalBase leader) {
        this.herdLeader = leader;
        this.herdLeaderUUID = leader != null ? leader.method_5667() : null;
    }

    @Override
    public void saveNbt(class_2487 nbt) {
        if (this.herdLeaderUUID != null) {
            nbt.method_10582("js.herd.herdleader", this.herdLeaderUUID.toString());
        }
    }

    @Override
    public void loadNbt(class_2487 nbt) {
        String leaderStr = nbt.method_10558("js.herd.herdleader");
        if (!leaderStr.isEmpty()) {
            this.herdLeaderUUID = UUID.fromString(leaderStr);
        }
    }

    @Override
    public void init() {
        this.maxDistance = (int)this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxDistanceToPackLeader();
        this.checkCooldown = 0;
        this.lookCooldown = 40;
    }

    @Override
    public void serverAiStep() {
        this.cleanupFollowers();
        if (this.isFollower()) {
            this.tickFollower();
        } else {
            this.tickLeader();
        }
    }

    private void tickFollower() {
        if (this.herdLeader == null || this.herdLeader.isDead() || !this.owner.method_18411()) {
            this.stopFollowing();
            return;
        }
        if (this.owner.getNavigationController().isDone() && this.isMovingToLeader) {
            this.isMovingToLeader = false;
        }
        double minDist = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMinDistanceToPackLeader();
        if (!this.isMovingToLeader && this.owner.method_5858((class_1297)this.herdLeader) > minDist) {
            if (this.checkCooldown > 0) {
                --this.checkCooldown;
            } else {
                this.tryMoveToLeader();
            }
        }
        this.owner.method_18408(this.herdLeader.method_23312(), this.maxDistance);
    }

    private void tryMoveToLeader() {
        if (this.owner.isDead()) {
            this.tickLeader();
            return;
        }
        if (this.owner.getModules().getMetabolismModule().isHungry() || this.owner.getModules().getMetabolismModule().isThirsty()) {
            return;
        }
        this.isMovingToLeader = true;
        this.owner.getTaskController().stopTask(TaskGoal.MOVEMENT);
        CompletableFuture moveTask = this.owner.getNavigationController().moveTo((class_1297)this.herdLeader, 1.0);
        if (moveTask != null) {
            moveTask.thenAccept(path -> {
                if (path == null) {
                    this.isMovingToLeader = false;
                    this.checkCooldown = 15;
                }
            });
        }
    }

    private void tickLeader() {
        if (this.herdLeaderUUID != null && this.herdLeader == null) {
            class_1937 class_19372 = this.owner.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 level = (class_3218)class_19372;
                class_1297 e = level.method_14190(this.herdLeaderUUID);
                if (e instanceof JSAnimalBase) {
                    JSAnimalBase base;
                    this.herdLeader = base = (JSAnimalBase)e;
                    if (base.isDead()) {
                        this.herdLeader.getModules().getHerdModule().removeFollower(this.owner);
                    } else {
                        this.herdLeader.getModules().getHerdModule().addFollower(this.owner);
                    }
                } else {
                    this.herdLeaderUUID = null;
                }
            }
        } else {
            this.mergeNearbyHerds();
        }
    }

    private void mergeNearbyHerds() {
        if (this.lookCooldown > 0) {
            --this.lookCooldown;
            return;
        }
        class_238 bounding = this.owner.method_5829().method_1014(32.0);
        List candidates = this.owner.method_37908().method_8390(JSAnimalBase.class, bounding, this::canHerdWith);
        if (candidates.isEmpty()) {
            this.lookCooldown = 200;
            return;
        }
        List<JSAnimalBase> leaders = candidates.stream().map(e -> e.getModules().getHerdModule().getTrueLeader()).filter(Objects::nonNull).distinct().toList();
        if (this.isLeader()) {
            leaders = new ArrayList<JSAnimalBase>(leaders);
            leaders.add(this.owner);
        }
        if (leaders.isEmpty()) {
            this.lookCooldown = 200;
            return;
        }
        JSAnimalBase bestLeader = leaders.stream().max(Comparator.comparingInt(l -> l.getModules().getHerdModule().getHerdSize())).orElse(this.owner);
        for (JSAnimalBase l2 : leaders) {
            if (l2 == bestLeader) continue;
            JSHerdModule lm = l2.getModules().getHerdModule();
            for (JSAnimalBase f : new HashSet<JSAnimalBase>(lm.followers)) {
                f.getModules().getHerdModule().startFollowing(bestLeader);
            }
            if (l2 == bestLeader) continue;
            l2.getModules().getHerdModule().startFollowing(bestLeader);
        }
        this.lookCooldown = 40;
    }

    public void addFollowers(Stream<? extends JSAnimalBase> newFollowers) {
        int maxSize = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxHerdSize();
        int remainingSlots = maxSize - this.followers.size();
        if (remainingSlots <= 0) {
            return;
        }
        newFollowers.filter(f -> f != this.owner).limit(remainingSlots).forEach(f -> {
            JSHerdModule mods = f.getModules().getHerdModule();
            if (!mods.isFollower() && !f.isDead()) {
                mods.startFollowing(this.owner);
            }
        });
    }

    public void startFollowing(JSAnimalBase leader) {
        if (leader == this.owner) {
            return;
        }
        this.stopFollowing();
        this.setHerdLeader(leader);
        leader.getModules().getHerdModule().addFollower(this.owner);
    }

    public void stopFollowing() {
        if (this.herdLeader != null) {
            this.herdLeader.getModules().getHerdModule().removeFollower(this.owner);
        }
        this.herdLeader = null;
        this.herdLeaderUUID = null;
        this.owner.method_35055();
        this.isMovingToLeader = false;
    }

    public void addFollower(JSAnimalBase animal) {
        if (animal != null && animal != this.owner) {
            this.followers.add(animal);
        }
    }

    public void removeFollower(JSAnimalBase animal) {
        this.followers.remove((Object)animal);
    }

    public int getHerdSize() {
        return this.isLeader() ? 1 + this.followers.size() : 1;
    }

    public boolean canBeFollowed() {
        int maxSize = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxHerdSize();
        return this.followers.size() < maxSize;
    }

    private boolean canHerdWith(JSAnimalBase other) {
        if (other == this.owner) {
            return false;
        }
        JSSocialGroupProperties props = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties();
        for (Class<class_1309> type : props.getHerdCompatible()) {
            if (!type.isInstance((Object)other)) continue;
            return true;
        }
        return false;
    }

    public boolean isFollower() {
        return this.herdLeader != null;
    }

    public boolean isLeader() {
        return this.herdLeader == null;
    }

    public JSAnimalBase getTrueLeader() {
        if (this.trueLeaderCooldown > 0) {
            --this.trueLeaderCooldown;
            return this.cachedTrueLeader;
        }
        JSHerdModule cur = this;
        HashSet<JSAnimalBase> visited = new HashSet<JSAnimalBase>();
        while (cur.herdLeader != null && cur.herdLeader != cur.owner) {
            if (!visited.add(cur.herdLeader)) {
                this.cachedTrueLeader = null;
                this.trueLeaderCooldown = 200;
                return null;
            }
            cur = cur.herdLeader.getModules().getHerdModule();
            if (cur.isFollower()) continue;
        }
        if (cur == null || cur.owner == null || cur.owner.isDead()) {
            this.cachedTrueLeader = null;
            this.trueLeaderCooldown = 200;
            return null;
        }
        this.cachedTrueLeader = cur.owner;
        this.trueLeaderCooldown = 20;
        return this.cachedTrueLeader;
    }

    private void cleanupFollowers() {
        this.followers.removeIf(f -> f == null || f.isDead() || f.getModules().getHerdModule().herdLeader != this.owner);
    }

    public JSAnimalBase getHerdLeader() {
        return this.herdLeader;
    }

    public UUID getHerdLeaderUUID() {
        return this.herdLeaderUUID;
    }

    public Set<JSAnimalBase> getFollowers() {
        return this.followers;
    }

    public boolean isMovingToLeader() {
        return this.isMovingToLeader;
    }

    public int getCheckCooldown() {
        return this.checkCooldown;
    }

    public int getLookCooldown() {
        return this.lookCooldown;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getTrueLeaderCooldown() {
        return this.trueLeaderCooldown;
    }

    public JSAnimalBase getCachedTrueLeader() {
        return this.cachedTrueLeader;
    }
}

